/*
 * Decompiled with CFR 0.152.
 */
package necesse.level.maps.regionSystem.managers;

import java.awt.Rectangle;
import java.util.stream.Stream;
import necesse.engine.util.GameLinkedList;
import necesse.engine.util.gameAreaSearch.GameAreaStream;
import necesse.engine.util.gameAreaSearch.JobsRegionSearch;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.jobs.LevelJob;
import necesse.level.maps.regionSystem.LevelRegionsSpliterator;
import necesse.level.maps.regionSystem.Region;

public class JobsLayerManager {
    protected final Level level;

    public JobsLayerManager(Level level) {
        this.level = level;
    }

    public Iterable<LevelJob> getJobsInRegion(int regionX, int regionY) {
        Region region = this.level.regionManager.getRegion(regionX, regionY, false);
        if (region == null) {
            return new GameLinkedList<LevelJob>();
        }
        return region.jobsLayer.getJobsInRegion();
    }

    public Stream<LevelJob> streamJobsInRegion(int regionX, int regionY) {
        Region region = this.level.regionManager.getRegion(regionX, regionY, false);
        if (region == null) {
            return Stream.empty();
        }
        return region.jobsLayer.streamJobsInRegion();
    }

    public Stream<LevelJob> streamJobsInTile(int tileX, int tileY) {
        Region region = this.level.regionManager.getRegionByTile(tileX, tileY, false);
        if (region == null) {
            return Stream.empty();
        }
        return region.jobsLayer.getTileJobsInRegion(tileX - region.tileXOffset, tileY - region.tileYOffset).stream();
    }

    public GameAreaStream<LevelJob> streamAreaJobs(int tileX, int tileY, int maxTileDistance) {
        return new JobsRegionSearch(this.level, tileX, tileY, maxTileDistance).streamEach();
    }

    public Stream<LevelJob> streamJobsInRegionsShape(int minX, int minY, int maxX, int maxY, int extraRegionRange) {
        return new LevelRegionsSpliterator(this.level, minX, minY, maxX, maxY, extraRegionRange).stream().flatMap(rp -> this.streamJobsInRegion(rp.x, rp.y)).filter(LevelJob::isValid);
    }

    public Stream<LevelJob> streamJobsInRegionsShape(Rectangle bounds, int extraRegionRange) {
        return new LevelRegionsSpliterator(this.level, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, extraRegionRange).stream().flatMap(rp -> this.streamJobsInRegion(rp.x, rp.y)).filter(LevelJob::isValid);
    }

    public Stream<LevelJob> streamInRegionsInRange(float levelX, float levelY, int range) {
        int minX = (int)(levelX - (float)range);
        int minY = (int)(levelY - (float)range);
        int maxX = (int)(levelX + (float)range);
        int maxY = (int)(levelY + (float)range);
        return this.streamJobsInRegionsShape(minX, minY, maxX, maxY, 0);
    }

    public Stream<LevelJob> streamInRegionsInTileRange(int levelX, int levelY, int tileRange) {
        int levelRange = tileRange * 32;
        int minX = levelX - levelRange;
        int minY = levelY - levelRange;
        int maxX = levelX + levelRange;
        int maxY = levelY + levelRange;
        return this.streamJobsInRegionsShape(minX, minY, maxX, maxY, 0);
    }

    public LevelJob addJob(LevelJob job, boolean override, boolean forceAdd) {
        Region region = this.level.regionManager.getRegionByTile(job.tileX, job.tileY, forceAdd);
        if (region == null) {
            return null;
        }
        return region.jobsLayer.addJob(job, override, forceAdd);
    }

    public LevelJob addJob(LevelJob job, boolean override) {
        return this.addJob(job, override, false);
    }

    public LevelJob addJob(LevelJob job) {
        return this.addJob(job, false);
    }
}

