/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.stream.Collectors;
import necesse.engine.GameLog;
import necesse.engine.GlobalData;
import necesse.engine.gameLoop.GameLoopListener;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.window.GameWindow;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.shader.GameShader;

public class DebugResourceWatcher
implements GameLoopListener {
    private static WatchService debugResourceWatcher;

    public DebugResourceWatcher() {
        try {
            Path[] directories;
            debugResourceWatcher = FileSystems.getDefault().newWatchService();
            for (Path directory : directories = new Path[]{Paths.get(GlobalData.rootPath() + "res/", new String[0]), Paths.get(GlobalData.rootPath() + "locale/", new String[0])}) {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        dir.register(debugResourceWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
                        return super.preVisitDirectory(dir, attrs);
                    }
                });
            }
            GlobalData.getCurrentGameLoop().addGameLoopListener(this);
            GameLog.debug.println("Started debug filer watcher. The game will automatically reload shader when files are changed.");
        }
        catch (IOException e) {
            GameLog.warn.println("Could not create debug resource watcher. See exception below:");
            e.printStackTrace(GameLog.warn);
        }
    }

    @Override
    public void frameTick(TickManager tickManager, GameWindow window) {
        WatchKey key = debugResourceWatcher.poll();
        if (key == null) {
            return;
        }
        Path directory = (Path)key.watchable();
        for (WatchEvent<?> pollEvent : key.pollEvents()) {
            WatchEvent.Kind<?> kind = pollEvent.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW || !(pollEvent.context() instanceof Path)) continue;
            Path filePath = directory.resolve((Path)pollEvent.context()).toAbsolutePath();
            String stringFilePath = filePath.toString();
            if (!Files.isRegularFile(filePath, new LinkOption[0])) continue;
            if (stringFilePath.endsWith(".glsl")) {
                GameLog.debug.println("Reloading shader file: " + filePath);
                List affectedShaders = GameResources.getShaders().values().stream().filter(shader -> stringFilePath.endsWith(shader.vertexPath + ".glsl") || stringFilePath.endsWith(shader.fragmentPath + ".glsl")).collect(Collectors.toList());
                for (GameShader affectedShader : affectedShaders) {
                    GameLog.debug.println("\t - reloading " + affectedShader);
                    affectedShader.reload();
                }
                if (!affectedShaders.isEmpty()) continue;
                GameLog.debug.println("\t - no shaders affected");
                continue;
            }
            if (stringFilePath.endsWith(".lang")) {
                Localization.reloadLanguageFiles();
                GameLog.debug.println("Reloading localization file: " + filePath);
                continue;
            }
            if (stringFilePath.endsWith(".png")) {
                boolean success = GameTexture.tryReloadTexture(filePath.toString());
                GameLog.debug.println("Reloading texture file: " + filePath + " - " + (success ? "success" : "failed"));
                continue;
            }
            if (!stringFilePath.endsWith(".ogg")) continue;
            boolean success = GameSound.tryReloadSound(filePath.toString());
            GameLog.debug.println("Reloading sound file: " + filePath + " - " + (success ? "success" : "failed"));
        }
        key.reset();
    }

    @Override
    public void drawTick(TickManager tickManager) {
    }

    @Override
    public boolean isDisposed() {
        return false;
    }
}

