/*
 * Decompiled with CFR 0.152.
 */
package necesse.gfx.ui;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.gfx.GameBackgroundTextures;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.ButtonColorTextures;
import necesse.gfx.ui.ButtonIcon;
import necesse.gfx.ui.ButtonStateTextures;
import necesse.gfx.ui.HoverStateTextures;

public class GameInterfaceStyle {
    public static ArrayList<GameInterfaceStyle> styles = new ArrayList();
    public static GameInterfaceStyle primal = new GameInterfaceStyle(new LocalMessage("settingsui", "primalui"), "primal");
    public static GameInterfaceStyle ghost;
    public static GameInterfaceStyle legacy;
    public static String defaultPath;
    public GameMessage displayName;
    public String texturesPath;
    public Color controllerFocusBoundsColor = new Color(50, 50, 200);
    public Color controllerFocusBoundsHighlightColor = new Color(50, 200, 50);
    public Color activeTextColor = new Color(20, 20, 20);
    public Color highlightTextColor = new Color(60, 30, 0);
    public Color inactiveTextColor = new Color(100, 100, 100);
    public Color activeButtonTextColor = new Color(20, 20, 20);
    public Color highlightButtonTextColor = new Color(60, 30, 0);
    public Color inactiveButtonTextColor = new Color(50, 50, 50);
    public Color activeFadedTextColor = new Color(20, 20, 20, 100);
    public Color highlightFadedTextColor = new Color(60, 30, 0, 100);
    public Color inactiveFadedTextColor = new Color(50, 50, 50, 100);
    public Color successTextColor = new Color(0, 125, 0);
    public Color warningTextColor = new Color(100, 100, 0);
    public Color errorTextColor = new Color(150, 0, 0);
    public Color textBoxTextColor = new Color(0, 0, 0);
    public Color selectionBoxActiveTextColor = new Color(20, 20, 20);
    public Color selectionBoxHighlightedTextColor = new Color(0, 0, 0);
    public Color selectionBoxInactiveTextColor = new Color(70, 70, 70);
    public Color inactiveElementColor = new Color(0.5f, 0.5f, 0.5f);
    public Color unfocusedElementColor = new Color(0.65f, 0.65f, 0.65f);
    public Color deadElementColor = new Color(0.4f, 0.4f, 0.4f);
    public Color activeElementColor = new Color(0.8f, 0.8f, 0.8f);
    public Color highlightElementColor = new Color(1.0f, 1.0f, 1.0f);
    public Color incursionModifierOrange = new Color(196, 79, 8);
    public Color incursionTierPurple = new Color(133, 49, 168);
    public Color progressBarOutline = new Color(20, 20, 20);
    public Color progressBarFill = new Color(220, 220, 220);
    public int formSpacing = 10;
    public int formTabOffset = 4;
    public int formTabEdgeSize = 4;
    public int formTabDownTextOffset = 1;
    public GameBackgroundTextures tooltip = new GameBackgroundTextures(7, 5, 2, () -> this.fromFile("tooltipbackground"), () -> this.fromFileRaw("tooltipbackgroundedge"));
    public GameBackgroundTextures form = new GameBackgroundTextures(12, 8, 0, () -> this.fromFile("formbackground"), () -> this.fromFileRaw("formbackgroundedge"));
    public GameBackgroundTextures textBox = new GameBackgroundTextures(7, 2, 2, () -> this.fromFile("textboxbackground"), () -> this.fromFileRaw("textboxbackgroundedge"));
    public GameBackgroundTextures indent = new GameBackgroundTextures(12, 6, 2, () -> this.fromFile("indentbackground"), () -> this.fromFileRaw("indentbackgroundedge"));
    public GameBackgroundTextures indentBorderless = new GameBackgroundTextures(12, 6, 2, () -> this.fromFile("indentborderlessbackground"), () -> this.fromFileRaw("indentborderlessbackgroundedge"));
    public GameBackgroundTextures selectionBox = new GameBackgroundTextures(7, 4, 0, () -> this.fromFile("selectionbox"), () -> this.fromFileRaw("selectionboxedge"));
    public GameBackgroundTextures selectionBox_highlighted = new GameBackgroundTextures(7, 4, 0, () -> this.fromFile("selectionbox_highlighted"), () -> this.fromFileRaw("selectionboxedge_highlighted"));
    public GameBackgroundTextures selectionBox_inactive = new GameBackgroundTextures(7, 4, 0, () -> this.fromFile("selectionbox_inactive"), () -> this.fromFileRaw("selectionboxedge_inactive"));
    public ButtonColorTextures button_32;
    public ButtonColorTextures button_24;
    public ButtonColorTextures button_20;
    public ButtonColorTextures button_16;
    public ButtonStateTextures formtab_16;
    public ButtonStateTextures formtabedge_16;
    public ButtonStateTextures formtab_20;
    public ButtonStateTextures formtabedge_20;
    public ButtonStateTextures formtab_24;
    public ButtonStateTextures formtabedge_24;
    public ButtonStateTextures formtab_32;
    public ButtonStateTextures formtabedge_32;
    public HoverStateTextures inventoryslot_big;
    public HoverStateTextures inventoryslot_big_new;
    public HoverStateTextures inventoryslot_big_note;
    public HoverStateTextures inventoryslot_small;
    public HoverStateTextures inventoryslot_small_new;
    public HoverStateTextures inventoryslot_small_note;
    public HoverStateTextures checkbox;
    public HoverStateTextures checkbox_checked;
    public HoverStateTextures button_select_big;
    public HoverStateTextures button_select_small;
    public HoverStateTextures slider;
    public HoverStateTextures biome_border;
    public HoverStateTextures biome_unknown;
    public HoverStateTextures button_navigate_vertical;
    public HoverStateTextures button_navigate_horizontal;
    public HoverStateTextures button_navigate_diagonal;
    public HoverStateTextures toggle_on;
    public HoverStateTextures toggle_off;
    public HoverStateTextures scrollbar;
    public HoverStateTextures steam_icon;
    public HoverStateTextures folder_icon;
    public HoverStateTextures config_icon;
    public ButtonStateTextures button_moveup;
    public ButtonStateTextures button_movedown;
    public ButtonIcon button_more;
    public ButtonIcon container_rename;
    public ButtonIcon container_rename_save;
    public ButtonIcon container_loot_all;
    public ButtonIcon container_storage_add;
    public ButtonIcon container_storage_config;
    public ButtonIcon container_storage_remove;
    public ButtonIcon inventory_quickstack_in;
    public ButtonIcon inventory_quickstack_out;
    public ButtonIcon inventory_sort;
    public ButtonIcon quickbar_teams;
    public ButtonIcon quickbar_settlement;
    public ButtonIcon quickbar_quests;
    public ButtonIcon quickbar_journal;
    public ButtonIcon quickbar_island_map;
    public ButtonIcon quickbar_world_map;
    public ButtonIcon quickbar_mining_icon;
    public ButtonIcon quickbar_door_on;
    public ButtonIcon quickbar_door_off;
    public ButtonIcon hotbar_locked;
    public ButtonIcon hotbar_unlocked;
    public ButtonIcon quickbar_stats_icon;
    public ButtonIcon quickbar_more;
    public ButtonIcon party_inventory_icon;
    public ButtonIcon settler_move_room;
    public ButtonIcon settler_assign_bed;
    public ButtonIcon settler_move_settlement;
    public ButtonIcon settler_banish;
    public ButtonIcon settler_diet;
    public ButtonIcon copy_button;
    public ButtonIcon paste_button;
    public ButtonIcon add_existing_button;
    public ButtonIcon copy_button_32;
    public ButtonIcon paste_button_32;
    public ButtonIcon config_button_32;
    public ButtonIcon button_hidden_big;
    public ButtonIcon button_shown_big;
    public ButtonIcon firework_random;
    public ButtonIcon firework_sphere;
    public ButtonIcon firework_splash;
    public ButtonIcon firework_disc;
    public ButtonIcon firework_star;
    public ButtonIcon firework_heart;
    public ButtonIcon firework_crackle;
    public ButtonIcon firework_nocrackle;
    public ButtonIcon firework_confetti;
    public ButtonIcon firework_flame;
    public ButtonIcon firework_red;
    public ButtonIcon firework_green;
    public ButtonIcon firework_blue;
    public ButtonIcon firework_pink;
    public ButtonIcon button_expanded_16;
    public ButtonIcon button_collapsed_16;
    public ButtonIcon button_expanded_24;
    public ButtonIcon button_collapsed_24;
    public ButtonIcon button_search_24;
    public ButtonIcon button_trash_24;
    public ButtonIcon button_checked_20;
    public ButtonIcon button_escaped_20;
    public ButtonIcon button_dash_20;
    public ButtonIcon button_plus_20_colored;
    public ButtonIcon button_minus_20_colored;
    public ButtonIcon button_help_20;
    public ButtonIcon button_plus_20;
    public ButtonIcon button_minus_20;
    public ButtonIcon button_plus_24;
    public ButtonIcon button_minus_24;
    public ButtonIcon button_reset_20;
    public ButtonIcon button_reset_16;
    public ButtonIcon priority_top;
    public ButtonIcon priority_high;
    public ButtonIcon priority_higher;
    public ButtonIcon priority_normal;
    public ButtonIcon priority_lower;
    public ButtonIcon priority_low;
    public ButtonIcon priority_last;
    public ButtonIcon priority_disabled;
    public ButtonIcon next_song;
    public ButtonIcon prev_song;
    public ButtonIcon play_song;
    public ButtonIcon pause_song;
    public ButtonIcon mirror_horizontal_32;
    public ButtonIcon mirror_vertical_32;
    public ButtonIcon rotate_clockwise_32;
    public ButtonIcon rotate_counterclockwise_32;
    public ButtonIcon rotate_180_32;
    public ButtonIcon toggle_tiles_off_32;
    public ButtonIcon toggle_tiles_on_32;
    public ButtonIcon toggle_objects_off_32;
    public ButtonIcon toggle_objects_on_32;
    public ButtonIcon toggle_object_entities_off_32;
    public ButtonIcon toggle_object_entities_on_32;
    public ButtonIcon toggle_wires_off_32;
    public ButtonIcon toggle_wires_on_32;
    public ButtonIcon toggle_clear_wires_off_32;
    public ButtonIcon toggle_clear_wires_on_32;
    public ButtonIcon keyboard_shift;
    public ButtonIcon keyboard_next;
    public ButtonIcon keyboard_spacebar;
    public ButtonIcon keyboard_backspace;
    public ButtonIcon keyboard_return;
    public ButtonIcon difficulty_casual_background;
    public ButtonIcon difficulty_adventure_background;
    public ButtonIcon difficulty_classic_background;
    public ButtonIcon difficulty_hard_background;
    public ButtonIcon difficulty_brutal_background;
    public ButtonIcon difficulty_casual;
    public ButtonIcon difficulty_adventure;
    public ButtonIcon difficulty_classic;
    public ButtonIcon difficulty_hard;
    public ButtonIcon difficulty_brutal;
    public ButtonIcon world_icon;
    public ButtonIcon discord_logo;
    public ButtonIcon steam_logo;
    public ButtonIcon twitter_logo;
    public ButtonIcon x_logo;
    public ButtonIcon youtube_logo;
    public ButtonIcon reddit_logo;
    public ButtonIcon camera_pan;
    public ButtonIcon world_type_survival;
    public ButtonIcon world_type_survival_toplayer;
    public ButtonIcon world_type_creative;
    public ButtonIcon world_type_creative_toplayer;
    public ButtonIcon eraser;
    public ButtonIcon pipette;
    public ButtonIcon godmode_on;
    public ButtonIcon godmode_off;
    public ButtonIcon creative_menu_toggle;
    public ButtonIcon creative_inventory_toggle;
    public GameTexture textinput_32;
    public GameTexture textinput_24;
    public GameTexture textinput_20;
    public GameTexture textinput_16;
    public GameTexture warning_icon;
    public GameTexture inventoryslot_icon_boots;
    public GameTexture inventoryslot_icon_chestplate;
    public GameTexture inventoryslot_icon_helmet;
    public GameTexture inventoryslot_icon_shoes;
    public GameTexture inventoryslot_icon_shirt;
    public GameTexture inventoryslot_icon_hat;
    public GameTexture inventoryslot_icon_trinket;
    public GameTexture inventoryslot_icon_trinket_ability;
    public GameTexture inventoryslot_icon_mount;
    public GameTexture inventoryslot_icon_trash;
    public GameTexture inventoryslot_icon_fuel;
    public GameTexture inventoryslot_icon_cooling_box_fuel;
    public GameTexture inventoryslot_icon_weapon;
    public GameTexture inventoryslot_icon_food;
    public GameTexture inventoryslot_icon_potion;
    public GameTexture inventoryslot_icon_gatewaytablet;
    public GameTexture inventoryslot_icon_upgrade_material;
    public GameTexture inventoryslot_icon_vinyl;
    public GameTexture note_island;
    public GameTexture spawn_island;
    public GameTexture settlement_island;
    public GameTexture note_disabled;
    public GameTexture note_locked;
    public GameTexture settler_house;
    public GameTexture settler_locked;
    public GameTexture icon_unknown;
    public GameTexture status_achievements_good;
    public GameTexture status_achievements_bad;
    public GameTexture status_version_good;
    public GameTexture status_version_bad;
    public GameTexture status_password;
    public GameTexture status_settings;
    public GameTexture status_mods_good;
    public GameTexture status_mods_bad;
    public GameTexture processing_arrow_empty;
    public GameTexture processing_arrow_full;
    public GameTexture progressbar_small_empty;
    public GameTexture progressbar_small_full;
    public GameTexture heart_outline;
    public GameTexture heart_fill;
    public GameTexture resilience_outline;
    public GameTexture resilience_fill;
    public GameTexture food_outline;
    public GameTexture food_fill;
    public GameTexture healthbar_big_background;
    public GameTexture healthbar_big_fill;
    public GameTexture healthbar_small_background;
    public GameTexture healthbar_small_fill;
    public GameTexture island_unknown;
    public GameTexture island_known;
    public GameTexture select;
    public GameTexture select_outline;
    public GameTexture arrow;
    public GameTexture input;
    public GameTexture chatbubble;
    public GameTexture tutorial_arrow;
    public GameTexture storage;
    public GameTexture workstation;
    public GameTexture cancel;
    public GameTexture deathmarker;
    public GameTexture deathmarker_note;
    public GameTexture visited_note;
    public GameTexture settlement_note_base;
    public GameTexture settlement_warning_base;
    public GameTexture settlement_error_base;
    public GameTexture settlement_note_shadow;
    public GameTexture settlement_warning_shadow;
    public GameTexture settlement_error_shadow;
    public GameTexture settlement_note_icon;
    public GameTexture settlement_warning_icon;
    public GameTexture settlement_error_icon;
    public GameTexture settler_mood_hungry;
    public GameTexture settler_mood_full_inventory;
    public GameTexture settler_mood_no_bed;
    public GameTexture settler_thought_bubble;
    public GameTexture settler_thought_agree;
    public GameTexture settler_thought_disagree;
    public GameTexture settler_thought_excited;
    public GameTexture settler_thought_love;
    public GameTexture settler_thought_anger;
    public GameTexture help_assign_chest;
    public GameTexture help_assign_bed;
    public GameTexture help_settler_happiness;
    public GameTexture paintbrush_handle;
    public GameTexture paintbrush_grayscale;
    public GameTexture rotate_arrow;
    public GameTexture qr_discord;
    public GameTexture qr_reddit_necesse;
    public GameTexture qr_steam_news;
    public GameTexture qr_x_necessegame;
    public GameTexture qr_youtube_necesse;
    public GameTexture qr_shockbyte;

    public static GameInterfaceStyle getStyle(String texturesPath) {
        for (GameInterfaceStyle setting : styles) {
            if (!setting.texturesPath.equals(texturesPath)) continue;
            return setting;
        }
        return styles.get(0);
    }

    public GameInterfaceStyle(GameMessage displayName, String texturesPath) {
        this.displayName = displayName;
        this.texturesPath = texturesPath;
    }

    protected GameTexture fromFileRaw(String name) throws FileNotFoundException {
        return GameTexture.fromFileRaw("ui/" + this.texturesPath + "/" + name);
    }

    protected GameTexture fromDefaultFileRaw(String name) throws FileNotFoundException {
        return GameTexture.fromFileRaw("ui/" + defaultPath + "/" + name);
    }

    protected GameTexture fromFile(String name) {
        try {
            return this.fromFileRaw(name);
        }
        catch (FileNotFoundException e) {
            return GameTexture.fromFile("ui/" + defaultPath + "/" + name);
        }
    }

    public void loadTextures() {
        this.tooltip.loadTextures();
        this.form.loadTextures();
        this.textBox.loadTextures();
        this.indent.loadTextures();
        this.indentBorderless.loadTextures();
        this.selectionBox.loadTextures();
        this.selectionBox_highlighted.loadTextures();
        this.selectionBox_inactive.loadTextures();
        this.button_32 = new ButtonColorTextures(this, "button_32");
        this.button_24 = new ButtonColorTextures(this, "button_24");
        this.button_20 = new ButtonColorTextures(this, "button_20");
        this.button_16 = new ButtonColorTextures(this, "button_16");
        this.formtab_16 = new ButtonStateTextures(this, "formtab_16");
        this.formtabedge_16 = new ButtonStateTextures(this, "formtabedge_16");
        this.formtab_20 = new ButtonStateTextures(this, "formtab_20");
        this.formtabedge_20 = new ButtonStateTextures(this, "formtabedge_20");
        this.formtab_24 = new ButtonStateTextures(this, "formtab_24");
        this.formtabedge_24 = new ButtonStateTextures(this, "formtabedge_24");
        this.formtab_32 = new ButtonStateTextures(this, "formtab_32");
        this.formtabedge_32 = new ButtonStateTextures(this, "formtabedge_32");
        this.button_more = new ButtonIcon(this, "button_more");
        this.textinput_32 = this.fromFile("textinput_32");
        this.textinput_24 = this.fromFile("textinput_24");
        this.textinput_20 = this.fromFile("textinput_20");
        this.textinput_16 = this.fromFile("textinput_16");
        this.toggle_on = new HoverStateTextures(this, "toggle_on");
        this.toggle_off = new HoverStateTextures(this, "toggle_off");
        this.scrollbar = new HoverStateTextures(this, "scrollbar");
        this.steam_icon = new HoverStateTextures(this, "steam_icon");
        this.folder_icon = new HoverStateTextures(this, "folder_icon");
        this.config_icon = new HoverStateTextures(this, "config_icon");
        this.warning_icon = this.fromFile("warning_icon");
        this.inventoryslot_big = new HoverStateTextures(this, "inventoryslot_big");
        this.inventoryslot_big_new = new HoverStateTextures(this, "inventoryslot_big_new");
        this.inventoryslot_big_note = new HoverStateTextures(this, "inventoryslot_big_note");
        this.inventoryslot_small = new HoverStateTextures(this, "inventoryslot_small");
        this.inventoryslot_small_new = new HoverStateTextures(this, "inventoryslot_small_new");
        this.inventoryslot_small_note = new HoverStateTextures(this, "inventoryslot_small_note");
        this.inventoryslot_icon_boots = this.fromFile("inventoryslot_icon_boots");
        this.inventoryslot_icon_chestplate = this.fromFile("inventoryslot_icon_chestplate");
        this.inventoryslot_icon_helmet = this.fromFile("inventoryslot_icon_helmet");
        this.inventoryslot_icon_shoes = this.fromFile("inventoryslot_icon_shoes");
        this.inventoryslot_icon_shirt = this.fromFile("inventoryslot_icon_shirt");
        this.inventoryslot_icon_hat = this.fromFile("inventoryslot_icon_hat");
        this.inventoryslot_icon_trinket = this.fromFile("inventoryslot_icon_trinket");
        this.inventoryslot_icon_trinket_ability = this.fromFile("inventoryslot_icon_trinket_ability");
        this.inventoryslot_icon_mount = this.fromFile("inventoryslot_icon_mount");
        this.inventoryslot_icon_trash = this.fromFile("inventoryslot_icon_trash");
        this.inventoryslot_icon_fuel = this.fromFile("inventoryslot_icon_fuel");
        this.inventoryslot_icon_cooling_box_fuel = this.fromFile("inventoryslot_icon_cooling_box_fuel");
        this.inventoryslot_icon_weapon = this.fromFile("inventoryslot_icon_weapon");
        this.inventoryslot_icon_food = this.fromFile("inventoryslot_icon_food");
        this.inventoryslot_icon_potion = this.fromFile("inventoryslot_icon_potion");
        this.inventoryslot_icon_gatewaytablet = this.fromFile("inventoryslot_icon_gatewaytablet");
        this.inventoryslot_icon_upgrade_material = this.fromFile("inventoryslot_icon_upgrade_material");
        this.inventoryslot_icon_vinyl = this.fromFile("inventoryslot_icon_vinyl");
        this.checkbox = new HoverStateTextures(this, "checkbox");
        this.checkbox_checked = new HoverStateTextures(this, "checkbox_checked");
        this.button_navigate_vertical = new HoverStateTextures(this, "button_navigate_vertical");
        this.button_navigate_horizontal = new HoverStateTextures(this, "button_navigate_horizontal");
        this.button_navigate_diagonal = new HoverStateTextures(this, "button_navigate_diagonal");
        this.button_select_big = new HoverStateTextures(this, "button_select_big");
        this.button_select_small = new HoverStateTextures(this, "button_select_small");
        this.slider = new HoverStateTextures(this, "slider");
        this.note_island = this.fromFile("note_island");
        this.spawn_island = this.fromFile("spawn_island");
        this.settlement_island = this.fromFile("settlement_island");
        this.note_disabled = this.fromFile("note_disabled");
        this.note_locked = this.fromFile("note_locked");
        this.settler_house = this.fromFile("settler_house");
        this.settler_locked = this.fromFile("settler_locked");
        this.icon_unknown = this.fromFile("icon_unknown");
        this.biome_border = new HoverStateTextures(this, "biome_border");
        this.biome_unknown = new HoverStateTextures(this, "biome_unknown");
        this.status_achievements_good = this.fromFile("status_achievements_good");
        this.status_achievements_bad = this.fromFile("status_achievements_bad");
        this.status_version_good = this.fromFile("status_version_good");
        this.status_version_bad = this.fromFile("status_version_bad");
        this.status_password = this.fromFile("status_password");
        this.status_settings = this.fromFile("status_settings");
        this.status_mods_good = this.fromFile("status_mods_good");
        this.status_mods_bad = this.fromFile("status_mods_bad");
        this.container_rename = new ButtonIcon(this, "container_rename");
        this.container_rename_save = new ButtonIcon(this, "container_rename_save");
        this.container_loot_all = new ButtonIcon(this, "container_loot_all");
        this.container_storage_add = new ButtonIcon(this, "container_storage_add");
        this.container_storage_config = new ButtonIcon(this, "container_storage_config");
        this.container_storage_remove = new ButtonIcon(this, "container_storage_remove");
        this.inventory_quickstack_in = new ButtonIcon(this, "inventory_quickstack_in");
        this.inventory_quickstack_out = new ButtonIcon(this, "inventory_quickstack_out");
        this.inventory_sort = new ButtonIcon(this, "inventory_sort");
        this.quickbar_teams = new ButtonIcon(this, "quickbar_teams");
        this.quickbar_settlement = new ButtonIcon(this, "quickbar_settlement");
        this.quickbar_quests = new ButtonIcon(this, "quickbar_quests");
        this.quickbar_journal = new ButtonIcon(this, "quickbar_journal_icon");
        this.quickbar_island_map = new ButtonIcon(this, "quickbar_island_map");
        this.quickbar_world_map = new ButtonIcon(this, "quickbar_world_map");
        this.quickbar_mining_icon = new ButtonIcon(this, "quickbar_mining_icon");
        this.quickbar_door_on = new ButtonIcon(this, "quickbar_door_on");
        this.quickbar_door_off = new ButtonIcon(this, "quickbar_door_off");
        this.hotbar_locked = new ButtonIcon(this, "hotbar_locked");
        this.hotbar_unlocked = new ButtonIcon(this, "hotbar_unlocked");
        this.quickbar_stats_icon = new ButtonIcon(this, "quickbar_stats_icon");
        this.quickbar_more = new ButtonIcon(this, "quickbar_more");
        this.party_inventory_icon = new ButtonIcon(this, "party_inventory_icon");
        this.button_moveup = new ButtonStateTextures(this, "button_moveup");
        this.button_movedown = new ButtonStateTextures(this, "button_movedown");
        this.processing_arrow_empty = this.fromFile("processing_arrow_empty");
        this.processing_arrow_full = this.fromFile("processing_arrow_full");
        this.progressbar_small_empty = this.fromFile("progressbar_small_empty");
        this.progressbar_small_full = this.fromFile("progressbar_small_full");
        this.heart_outline = this.fromFile("heart_outline");
        this.heart_fill = this.fromFile("heart_fill");
        this.resilience_outline = this.fromFile("resilience_outline");
        this.resilience_fill = this.fromFile("resilience_fill");
        this.food_outline = this.fromFile("food_outline");
        this.food_fill = this.fromFile("food_fill");
        this.healthbar_big_background = this.fromFile("healthbar_big_background");
        this.healthbar_big_fill = this.fromFile("healthbar_big_fill");
        this.healthbar_small_background = this.fromFile("healthbar_small_background");
        this.healthbar_small_fill = this.fromFile("healthbar_small_fill");
        this.island_unknown = this.fromFile("island_unknown");
        this.island_known = this.fromFile("island_known");
        this.settler_move_room = new ButtonIcon(this, "settlermoveroom");
        this.settler_assign_bed = new ButtonIcon(this, "settlerassignbed");
        this.settler_move_settlement = new ButtonIcon(this, "settlermovesettlement");
        this.settler_banish = new ButtonIcon(this, "settlerbanish");
        this.settler_diet = new ButtonIcon(this, "settlerdiet");
        this.select = this.fromFile("select");
        this.select_outline = this.fromFile("select_outline");
        this.arrow = this.fromFile("arrow");
        this.input = this.fromFile("input");
        this.chatbubble = this.fromFile("chatbubble");
        this.tutorial_arrow = this.fromFile("tutorial_arrow");
        this.storage = this.fromFile("storage");
        this.workstation = this.fromFile("workstation");
        this.cancel = this.fromFile("cancel");
        this.deathmarker = this.fromFile("deathmarker");
        this.deathmarker_note = this.fromFile("deathmarker_note");
        this.visited_note = this.fromFile("visited_note");
        this.settlement_note_base = this.fromFile("settlement_note_base");
        this.settlement_warning_base = this.fromFile("settlement_warning_base");
        this.settlement_error_base = this.fromFile("settlement_error_base");
        this.settlement_note_shadow = this.fromFile("settlement_note_shadow");
        this.settlement_warning_shadow = this.fromFile("settlement_warning_shadow");
        this.settlement_error_shadow = this.fromFile("settlement_error_shadow");
        this.settlement_note_icon = this.fromFile("settlement_note_icon");
        this.settlement_warning_icon = this.fromFile("settlement_warning_icon");
        this.settlement_error_icon = this.fromFile("settlement_error_icon");
        this.settler_mood_hungry = this.fromFile("settler_mood_hungry");
        this.settler_mood_full_inventory = this.fromFile("settler_mood_full_inventory");
        this.settler_mood_no_bed = this.fromFile("settler_mood_no_bed");
        this.settler_thought_bubble = this.fromFile("settler_thought_bubble");
        this.settler_thought_agree = this.fromFile("settler_thought_agree");
        this.settler_thought_disagree = this.fromFile("settler_thought_disagree");
        this.settler_thought_excited = this.fromFile("settler_thought_excited");
        this.settler_thought_love = this.fromFile("settler_thought_love");
        this.settler_thought_anger = this.fromFile("settler_thought_anger");
        this.help_assign_chest = this.fromFile("help_assign_chest");
        this.help_assign_bed = this.fromFile("help_assign_bed");
        this.help_settler_happiness = this.fromFile("help_settler_happiness");
        this.paintbrush_handle = this.fromFile("paintbrush_handle");
        this.paintbrush_grayscale = this.fromFile("paintbrush_grayscale");
        this.rotate_arrow = this.fromFile("rotate_arrow");
        this.qr_discord = this.fromFile("qr_discord");
        this.qr_reddit_necesse = this.fromFile("qr_reddit_necesse");
        this.qr_steam_news = this.fromFile("qr_steam_news");
        this.qr_x_necessegame = this.fromFile("qr_x_necessegame");
        this.qr_youtube_necesse = this.fromFile("qr_youtube_necesse");
        this.qr_shockbyte = this.fromFile("qr_shockbyte");
        this.copy_button = new ButtonIcon(this, "copy_button");
        this.paste_button = new ButtonIcon(this, "paste_button");
        this.add_existing_button = new ButtonIcon(this, "add_existing_button");
        this.copy_button_32 = new ButtonIcon(this, "copy_button_32");
        this.paste_button_32 = new ButtonIcon(this, "paste_button_32");
        this.config_button_32 = new ButtonIcon(this, "config_button_32");
        this.button_hidden_big = new ButtonIcon(this, "button_hidden_big");
        this.button_shown_big = new ButtonIcon(this, "button_shown_big");
        this.firework_random = new ButtonIcon(this, "firework_random");
        this.firework_sphere = new ButtonIcon(this, "firework_sphere");
        this.firework_splash = new ButtonIcon(this, "firework_splash");
        this.firework_disc = new ButtonIcon(this, "firework_disc");
        this.firework_star = new ButtonIcon(this, "firework_star");
        this.firework_heart = new ButtonIcon(this, "firework_heart");
        this.firework_crackle = new ButtonIcon(this, "firework_crackle");
        this.firework_nocrackle = new ButtonIcon(this, "firework_nocrackle");
        this.firework_confetti = new ButtonIcon(this, "firework_confetti", false);
        this.firework_flame = new ButtonIcon(this, "firework_flame", false);
        this.firework_red = new ButtonIcon(this, "firework_red", false);
        this.firework_green = new ButtonIcon(this, "firework_green", false);
        this.firework_blue = new ButtonIcon(this, "firework_blue", false);
        this.firework_pink = new ButtonIcon(this, "firework_pink", false);
        this.button_expanded_16 = new ButtonIcon(this, "button_expanded_16");
        this.button_collapsed_16 = new ButtonIcon(this, "button_collapsed_16");
        this.button_expanded_24 = new ButtonIcon(this, "button_expanded_24");
        this.button_collapsed_24 = new ButtonIcon(this, "button_collapsed_24");
        this.button_search_24 = new ButtonIcon(this, "button_search_24");
        this.button_trash_24 = new ButtonIcon(this, "button_trash_24");
        this.button_checked_20 = new ButtonIcon(this, "button_checked_20", false);
        this.button_escaped_20 = new ButtonIcon(this, "button_escaped_20", false);
        this.button_dash_20 = new ButtonIcon(this, "button_dash_20", false);
        this.button_plus_20_colored = new ButtonIcon(this, "button_plus_20_colored", false);
        this.button_minus_20_colored = new ButtonIcon(this, "button_minus_20_colored", false);
        this.button_help_20 = new ButtonIcon(this, "button_help_20");
        this.button_plus_20 = new ButtonIcon(this, "button_plus_20");
        this.button_minus_20 = new ButtonIcon(this, "button_minus_20");
        this.button_plus_24 = new ButtonIcon(this, "button_plus_24");
        this.button_minus_24 = new ButtonIcon(this, "button_minus_24");
        this.button_reset_20 = new ButtonIcon(this, "button_reset_20");
        this.button_reset_16 = new ButtonIcon(this, "button_reset_16");
        this.priority_top = new ButtonIcon(this, "priority_top");
        this.priority_high = new ButtonIcon(this, "priority_high");
        this.priority_higher = new ButtonIcon(this, "priority_higher");
        this.priority_normal = new ButtonIcon(this, "priority_normal");
        this.priority_lower = new ButtonIcon(this, "priority_lower");
        this.priority_low = new ButtonIcon(this, "priority_low");
        this.priority_last = new ButtonIcon(this, "priority_last");
        this.priority_disabled = new ButtonIcon(this, "priority_disabled");
        this.next_song = new ButtonIcon(this, "next_song");
        this.prev_song = new ButtonIcon(this, "prev_song");
        this.play_song = new ButtonIcon(this, "play_song");
        this.pause_song = new ButtonIcon(this, "pause_song");
        this.mirror_horizontal_32 = new ButtonIcon(this, "mirror_horizontal_32");
        this.mirror_vertical_32 = new ButtonIcon(this, "mirror_vertical_32");
        this.rotate_clockwise_32 = new ButtonIcon(this, "rotate_clockwise_32");
        this.rotate_counterclockwise_32 = new ButtonIcon(this, "rotate_counterclockwise_32");
        this.rotate_180_32 = new ButtonIcon(this, "rotate_180_32");
        this.toggle_tiles_off_32 = new ButtonIcon(this, "toggle_tiles_off_32");
        this.toggle_tiles_on_32 = new ButtonIcon(this, "toggle_tiles_on_32");
        this.toggle_objects_off_32 = new ButtonIcon(this, "toggle_objects_off_32");
        this.toggle_objects_on_32 = new ButtonIcon(this, "toggle_objects_on_32");
        this.toggle_object_entities_off_32 = new ButtonIcon(this, "toggle_object_entities_off_32");
        this.toggle_object_entities_on_32 = new ButtonIcon(this, "toggle_object_entities_on_32");
        this.toggle_wires_off_32 = new ButtonIcon(this, "toggle_wires_off_32");
        this.toggle_wires_on_32 = new ButtonIcon(this, "toggle_wires_on_32");
        this.toggle_clear_wires_off_32 = new ButtonIcon(this, "toggle_clear_wires_off_32");
        this.toggle_clear_wires_on_32 = new ButtonIcon(this, "toggle_clear_wires_on_32");
        this.keyboard_shift = new ButtonIcon(this, "keyboard_shift");
        this.keyboard_next = new ButtonIcon(this, "keyboard_next");
        this.keyboard_spacebar = new ButtonIcon(this, "keyboard_spacebar");
        this.keyboard_backspace = new ButtonIcon(this, "keyboard_backspace");
        this.keyboard_return = new ButtonIcon(this, "keyboard_return");
        this.difficulty_casual_background = new ButtonIcon(this, "difficulty_casual_background", false);
        this.difficulty_adventure_background = new ButtonIcon(this, "difficulty_adventure_background", false);
        this.difficulty_classic_background = new ButtonIcon(this, "difficulty_classic_background", false);
        this.difficulty_hard_background = new ButtonIcon(this, "difficulty_hard_background", false);
        this.difficulty_brutal_background = new ButtonIcon(this, "difficulty_brutal_background", false);
        this.difficulty_casual = new ButtonIcon(this, "difficulty_casual", false);
        this.difficulty_adventure = new ButtonIcon(this, "difficulty_adventure", false);
        this.difficulty_classic = new ButtonIcon(this, "difficulty_classic", false);
        this.difficulty_hard = new ButtonIcon(this, "difficulty_hard", false);
        this.difficulty_brutal = new ButtonIcon(this, "difficulty_brutal", false);
        this.world_icon = new ButtonIcon(this, "world_icon", false);
        this.discord_logo = new ButtonIcon(this, "discord_logo", false);
        this.steam_logo = new ButtonIcon(this, "steam_logo", false);
        this.twitter_logo = new ButtonIcon(this, "twitter_logo", false);
        this.x_logo = new ButtonIcon(this, "x_logo", false);
        this.youtube_logo = new ButtonIcon(this, "youtube_logo", false);
        this.reddit_logo = new ButtonIcon(this, "reddit_logo", false);
        this.camera_pan = new ButtonIcon(this, "camerapan", false);
        this.world_type_survival = new ButtonIcon(this, "world_type_survival", false);
        this.world_type_survival_toplayer = new ButtonIcon(this, "world_type_survival_toplayer", false);
        this.world_type_creative = new ButtonIcon(this, "world_type_creative", false);
        this.world_type_creative_toplayer = new ButtonIcon(this, "world_type_creative_toplayer", false);
        this.eraser = new ButtonIcon(this, "eraser", false);
        this.pipette = new ButtonIcon(this, "pipette", false);
        this.godmode_on = new ButtonIcon(this, "creative_godmode_on", false);
        this.godmode_off = new ButtonIcon(this, "creative_godmode_off", false);
        this.creative_menu_toggle = new ButtonIcon(this, "creative_menu_toggle", false);
        this.creative_inventory_toggle = new ButtonIcon(this, "creative_inventory_toggle", false);
    }

    static {
        styles.add(primal);
        ghost = new GameInterfaceStyle(new LocalMessage("settingsui", "ghostui"), "ghost");
        GameInterfaceStyle.ghost.activeTextColor = new Color(200, 200, 200);
        GameInterfaceStyle.ghost.highlightTextColor = new Color(255, 255, 255);
        GameInterfaceStyle.ghost.inactiveTextColor = new Color(120, 120, 120);
        GameInterfaceStyle.ghost.activeFadedTextColor = new Color(140, 140, 140);
        GameInterfaceStyle.ghost.highlightFadedTextColor = new Color(200, 200, 200);
        GameInterfaceStyle.ghost.inactiveFadedTextColor = new Color(80, 80, 80);
        GameInterfaceStyle.ghost.activeButtonTextColor = new Color(220, 220, 220);
        GameInterfaceStyle.ghost.highlightButtonTextColor = new Color(255, 255, 255);
        GameInterfaceStyle.ghost.inactiveButtonTextColor = new Color(150, 150, 150);
        GameInterfaceStyle.ghost.successTextColor = new Color(50, 220, 50);
        GameInterfaceStyle.ghost.warningTextColor = new Color(220, 220, 50);
        GameInterfaceStyle.ghost.errorTextColor = new Color(220, 50, 50);
        GameInterfaceStyle.ghost.incursionModifierOrange = new Color(196, 79, 8);
        GameInterfaceStyle.ghost.selectionBoxActiveTextColor = new Color(240, 240, 240);
        GameInterfaceStyle.ghost.selectionBoxHighlightedTextColor = new Color(255, 255, 255);
        GameInterfaceStyle.ghost.selectionBoxInactiveTextColor = new Color(150, 150, 150);
        GameInterfaceStyle.ghost.progressBarOutline = new Color(10, 10, 20);
        GameInterfaceStyle.ghost.progressBarFill = new Color(149, 152, 105);
        GameInterfaceStyle.ghost.form.edgeResolution = 12;
        GameInterfaceStyle.ghost.form.edgeMargin = 6;
        GameInterfaceStyle.ghost.formSpacing = 8;
        GameInterfaceStyle.ghost.formTabOffset = 2;
        GameInterfaceStyle.ghost.formTabEdgeSize = 2;
        GameInterfaceStyle.ghost.indent.edgeResolution = 7;
        GameInterfaceStyle.ghost.indent.edgeMargin = 2;
        styles.add(ghost);
        legacy = new GameInterfaceStyle(new LocalMessage("settingsui", "legacyui"), "legacy");
        GameInterfaceStyle.legacy.activeTextColor = new Color(35, 35, 35);
        GameInterfaceStyle.legacy.highlightTextColor = new Color(0, 0, 0);
        GameInterfaceStyle.legacy.inactiveTextColor = new Color(100, 100, 100);
        GameInterfaceStyle.legacy.activeButtonTextColor = new Color(35, 35, 35);
        GameInterfaceStyle.legacy.highlightButtonTextColor = new Color(0, 0, 0);
        GameInterfaceStyle.legacy.inactiveButtonTextColor = new Color(50, 50, 50);
        GameInterfaceStyle.legacy.activeFadedTextColor = new Color(35, 35, 35, 100);
        GameInterfaceStyle.legacy.highlightFadedTextColor = new Color(0, 0, 0, 100);
        GameInterfaceStyle.legacy.inactiveFadedTextColor = new Color(50, 50, 50, 100);
        GameInterfaceStyle.legacy.warningTextColor = new Color(175, 175, 0);
        GameInterfaceStyle.legacy.incursionModifierOrange = new Color(171, 67, 3);
        GameInterfaceStyle.legacy.form.edgeResolution = 7;
        GameInterfaceStyle.legacy.form.edgeMargin = 5;
        GameInterfaceStyle.legacy.formSpacing = 6;
        GameInterfaceStyle.legacy.formTabOffset = 1;
        GameInterfaceStyle.legacy.formTabEdgeSize = 3;
        GameInterfaceStyle.legacy.indent.edgeResolution = 7;
        GameInterfaceStyle.legacy.indent.edgeMargin = 2;
        styles.add(legacy);
        defaultPath = "primal";
    }
}

