/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine;

import java.awt.Color;
import java.awt.Rectangle;
import java.time.LocalDate;
import java.util.LinkedList;
import necesse.engine.GamePatchNotes;
import necesse.engine.GameVersion;
import necesse.engine.Settings;
import necesse.engine.platforms.PlatformManager;
import necesse.gfx.drawOptions.PositionedDrawOptionsBox;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameFont.FontOptions;

public class GameInfo {
    public static final String name = "Necesse";
    public static final int appID = 1169040;
    public static final String version = "1.0.1";
    public static final String bottomRightInfo = null;
    public static final String inDevelopmentInfo = null;
    public static final GameVersion gameVersion = new GameVersion("1.0.1");
    public static final int hotfix = 0;
    public static final String discord_invite_url = "https://discord.gg/YBhNh52dpy";
    public static final String steam_news_url = "https://store.steampowered.com/news/app/1169040";
    public static final String twitter_url = "https://twitter.com/NecesseGame";
    public static final String x_url = "https://x.com/NecesseGame";
    public static final String reddit_url = "https://reddit.com/r/Necesse";
    public static final String youtube_url = "https://www.youtube.com/@Necesse?sub_confirmation=1";
    public static final String website_url = "https://necessegame.com/";
    public static final String wiki_url = "https://necessewiki.com/";
    public static final String shockbyte_url = "https://shockbyte.com/partner/necesse";
    public static int recentPatchYear = 2025;
    public static int recentPatchMonth = 10;
    public static int recentPatchDay = 16;
    public static LinkedList<GamePatchNotes> patchNotes = new LinkedList();

    public static String getFullVersionString() {
        String out = version;
        return out;
    }

    public static String getVersionStringAndBuild() {
        return "1.0.1 build " + PlatformManager.getPlatform().getPlatformAppBuild();
    }

    public static String getFullVersionStringAndBuild() {
        return GameInfo.getFullVersionString() + " build " + PlatformManager.getPlatform().getPlatformAppBuild();
    }

    public static PositionedDrawOptionsBox getInDevelopmentDrawBox(boolean centered, boolean snappedBottom) {
        if (inDevelopmentInfo != null) {
            long time = System.currentTimeMillis() % 2500L;
            Color color = new Color(Color.HSBtoRGB((float)time / 2500.0f, 0.2f, 1.0f));
            final FontOptions fontOptions = new FontOptions(16).outline().color(color);
            final int width = FontManager.bit.getWidthCeil(inDevelopmentInfo, fontOptions);
            final int height = FontManager.bit.getHeightCeil(inDevelopmentInfo, fontOptions);
            final int drawOffsetX = centered ? -width / 2 : 0;
            final int drawOffsetY = snappedBottom ? -height : 0;
            return new PositionedDrawOptionsBox(){

                @Override
                public Rectangle getBoundingBox(int drawX, int drawY) {
                    return new Rectangle(drawX + drawOffsetX, drawY + drawOffsetY, width, height);
                }

                @Override
                public void draw(int drawX, int drawY) {
                    FontManager.bit.drawString(drawX + drawOffsetX, drawY + drawOffsetY, inDevelopmentInfo, fontOptions);
                }
            };
        }
        return null;
    }

    public static void refreshPatchNotesOpen() {
        LocalDate now = LocalDate.now();
        Settings.patchNotesOpenYear = now.getYear();
        Settings.patchNotesOpenMonth = now.getMonthValue();
        Settings.patchNotesOpenDay = now.getDayOfMonth();
    }

    public static boolean shouldPatchNotesBlink() {
        LocalDate patchDate = LocalDate.of(recentPatchYear, recentPatchMonth, recentPatchDay);
        LocalDate lastOpenDate = LocalDate.of(Settings.patchNotesOpenYear, Settings.patchNotesOpenMonth, Settings.patchNotesOpenDay);
        return lastOpenDate.isBefore(patchDate);
    }

    static {
        patchNotes.add(new GamePatchNotes("Version 1.0", "Date: 2025.10.16", "https://store.steampowered.com/news/app/1169040/view/676227805148610689", "===Additions:===\nAdded completely new world generation with infinite seamless biomes, biome blending and more.\nAdded the ability to migrate your old Early Access world to be placed in the new world generation.\nAdded a completely new Fallen Altar perk tree that modify the incursions you open.\nAdded 48 unique perks to the Fallen Altar perk tree.\nAdded final incursion with new enemies and final boss at the end of the Fallen Altar perk tree.\nAdded 4 new secret weapons that drop from the final boss.\nAdded more permanent health upgrade items as boss drops.\nAdded over 350 new sound effects throughout the game.\nAdded 8 new soundtracks and vinyls to the game.\nAdded the ability to place ladders from the cave to reach the surface.\nAdded a ton of community submitted presets to the world generation. Thank you community <3\nAdded interactions between settlers when they are idle.\nAdded 4 new achievements.\nAdded map markers that you can place and name on the map.\nAdded a complete set of Runic tools crafted at the Demonic Anvil.\nAdded a complete set of Quartz tools crafted at the Demonic Anvil.\nAdded Sprinkler magic weapon crafted at the Demonic Anvil.\nAdded Galvanic Hammer crafted at the Demonic Anvil.\nAdded Six Shooter bought from Gunsmith after defeating the Swamp Guardian.\nAdded Vampiric Lamp crafted at the Tungsten Anvil.\nAdded Chromatic Spellbook crafted at the Tungsten Anvil.\nAdded Topaz Staff crafted at the Tungsten Anvil.\nAdded Unlabeled Potion crafted at the Tungsten Anvil.\nAdded Hexed Blade crafted at the Tungsten Anvil.\nAdded Reanimation Bow crafted at the Tungsten Anvil.\nAdded The Perfect Storm crafted at the Fallen Anvil.\nAdded Aged Champion sword dropped by its wielder.\nAdded Aged Champion armor set dropped by its wielder.\nAdded Soldier's armor crafted at the Iron Anvil.\nAdded Gunslinger armor crafted at the Demonic Anvil.\nAdded Thief's armor crafted at the Demonic Anvil.\nAdded Arachnid armor crafted at the Demonic Anvil.\nAdded Sharpshooter armor crafted at the Tungsten Anvil.\nAdded Soulseed armor crafted at the Tungsten Anvil.\nAdded Ancestor armor crafted at the Tungsten Anvil.\nAdded Deepfrost armor crafted at the Tungsten Anvil.\nAdded Pharaohs armor crafted at the Tungsten Anvil.\nAdded Battle Chef armor crafted at the Fallen Anvil.\nAdded Caveling's Foot trinket as a rare drop from Cavelings in the regular caves.\nAdded Caveling's Collection trinket as a rare drop from Cavelings in the deep caves.\nAdded Shooting Flameling to deep forest caves.\nAdded Topaz Crystals found in the Deep Plains Caves.\nAdded Topaz Clusters and Gravel crafted at the Tungsten Landscaping Station.\nAdded Raven Feather crafting material found in Incursions.\nAdded Raven Walls, Doors, Floors and Windows crafted at the Fallen Workstation.\nAdded Raven Skull crafted at the Fallen Landscaping Station.\nAdded Raven Effigy crafted at the Fallen Landscaping Station.\nAdded Raven Statue crafted at the Fallen Landscaping Station.\nAdded Raven Nest and Empty Raven Nest crafted at the Fallen Landscaping Station.\nAdded Electrified Mana crafting material found in Incursions.\nAdded Arcanic Walls, Doors, Floors and Windows crafted at the Fallen Workstation.\nAdded Arcanic Lamp crafted at the Fallen Carpenters Bench.\nAdded Arcanic Column crafted at the Fallen Carpenters Bench.\nAdded Arcanic Crates crafted at the Fallen Landscaping Station.\nAdded Arcanic Machinery crafted at the Fallen Landscaping Station.\nAdded the Blacksmith, Witch and Majestic Pig Statue crafted at the Fallen Landscaping Station.\nAdded Ascended Void Tiles crafted at the Fallen Landscaping Station.\nAdded Stool crafted at the Carpenters Bench.\nAdded Large Keg crafted at the Tungsten Carpenters Bench.\nAdded Bar Shelf crafted at the Tungsten Carpenters Bench.\nAdded Sink crafted at the Landscaping Station.\nAdded Tungsten Sink crafted at the Tungsten Landscaping Station.\nAdded Necesse logo to the main menu.\nAdded game credits to the main menu and when you've defeated the last boss.\nAdded Steam Trading Cards.\n\n===Changes/misc:===\nCompletely overhauled balance and progression throughout the entire game.\nReworked settlements to have bounds and added the ability to have more settlements on one map.\nSettlements will now disband over time if they have no flag placed down.\nSettlements can now be expanded in the settlement settings menu.\nGateway Tablet Tier is now capped at Tier 10 instead of Tier 6.\nEquipment can now be upgraded to Tier 10.\nGateway Tablets now have 2 Incursion Modifiers from tier 4 to 7.\nGateway Tablets now have 3 Incursions Modifiers from Tier 8 and above.\nReplaced Travel Scrolls with new Teleport Scrolls.\nReplaced Travelstone with Teleportstone.\nReworked map items to place a map marker where they point to.\nWeapon damage and crit chance tooltip will now both include player modifiers and its enchantment.\nHome Portals from the Portal Flask will now show on the map for the owner and team members.\nRemoved the settlement defend zone mechanic.\nRemoved find island mission from the Explorer settler.\nPirate telescope now gives increased map discovery range.\nReworked map discoveries, making it much more smooth.\nExpanded tool progression between each biome.\nHover Boots are now obtained by completing plains cave journal challenges.\nThe Shipping Chest is now obtained by completing the Defeat Chieftain elder quest.\nLandscaping Station can now be crafted at Demonic Workstation.\nThe Steam Controller configurator is now using localizations from the community (Thank you translators!)\nImproved netcode when changing levels or using ladders while on an unstable connection.\nMost enemies and animals will now not wander far from where they spawned.\nSecond Wind Charm now only refreshes one dash stack instead of all.\nUpdated the Sand Knife sprites.\nBosses will now only trigger music to start when you're close to them.\nMultiplayer boss health scaling will now only when players are close to the boss.\nBanner of War can no longer be placed in Incursions, unless your Fallen Altar has the \"War never changes\" perk.\nReworked the Arcanic armor set bonus.\nThe Arcanic armor set is now crafted at the Fallen Anvil.\nThe Ravenlords armor set is now crafted at the Fallen Anvil.\nThe Kinetic Boots trinket is now a random drop from the Sunlight Champion and the Moonlight Dancer.\nReorganized the main menu.\nRemoved job search range setting. Settlers will now search for jobs within the settlement bounds.\nThe Demonic armor set bonus now has an active ability that consumes health to enter a demonic rage.\nThe Quartz helmet armor set bonus now grants resilience and movement speed when hit.\nRemoved world border size setting for now.\nThe recipes for converting Tier 2 essences to other essences is now more expensive.\nReduced minecart tracks crafting cost and made you able to place them much faster.\nStink flask buff is now considered important.\nIncreased the item upgrade cost during incursion stage.\nIncreased the amount of upgrade shards you get back when you salvage a higher tier item.\nLightning Hammer attacks will now no longer go through walls.\nReduced Lightning Hammer resilience generation.\nReduced the speed of Mother Slime earthquake attack.\nIncreased the amount of mana regen from mana regen potions.\nGame freezes will now show the crash report to help solve them.\n\n===Fixes:===\nFixed settlement flag no owner question mark being offset on the flag.\nFixed trial rooms spawning the same main item too often.\nFixed wall candle smoke particles always coming from the center of a tile.\nFixed wrong message displaying when trying to sit on occupied bench.\nFixed Stabby Bush explosion being able to hit friendlies.\nFixed Brutes Battleaxe sometimes not registering hits when dashing.\nFixed buff weapon projectiles being drawn with an incorrect height offset.\nFixed mirroring of some large objects in presets not always working.\nFixed Flameling not playing sound when shooting fireballs.\nFixed missing pixels on some armor sets.\nFixed placing wild flowers showing as potted flowers until they're updated.\nFixed placed coins on shore tiles getting destroyed when placing something near them.\nFixed deaths to Void Traps showing as \"Unknown\".\nFixed placing torch hotkey in creative mode sometimes placing it extremely far away.\nFixed hovering on overlapping context menus highlighting both menus.\nFixed not being able to properly select sub-context menus with controllers.\nFixed Double Streetlamp not being rotatable / mirrorable in the preset editor.\nFixed Necrotic Bow summons dying too quickly.\nFixed Blood Claw right click attack sometimes not dealing any damage.\nFixed going to the map edges with a torch stopping the light from refreshing.\nFixed replacing objects and tiles sometimes causing desync.\nFixed carpets drawing on top of some objects like campfires and minecart tracks.\nFixed using benches and beds that are already in use giving the wrong error message.\nFixed most Statues giving the Banner of Peace buff.\nFixed magic glyphs not showing the correct settings when first placed.\nFixed issue where Lightning Hammer would deal more damage to worm bosses than intended.\nFixed Deep Rock tile having the wrong map color.\nFixed Incursion Flamelings always spawning in the bottom right.\n\nAnd some other smaller changes and fixes."));
        patchNotes.add(new GamePatchNotes("Version 0.33.1", "Date: 2025.07.22", "https://store.steampowered.com/news/app/1169040/view/519719643731986267", "===Changes:===\nFixed switching creative menu tabs not stopping typing in search, causing all character keys to stop functioning.\nFixed tooltips sometimes not showing when using controller cursor mode.\nFixed Miners Prosthetic being able to mine further away when using smart mining.\nFixed raids counting enchantments for best equipment value resulting in spawning raiders with weapons and armor above the intended tier.\nFixed wild beehive and cow skeleton not showing in creative menu list.\nFixed using recall, travel scrolls or other teleportation while dragging and item causing the item to be dropped.\nFixed chat cutting off messages when the log becomes too long.\nFixed cheat chat commands not requiring a second usage to activate in creative mode.\nClarified warnings about joining creative mode characters to survival worlds etc.\nUpdated community translations (thank you translators!).\n\n===Earlier hotfixes:===\nFixed controller focus snapping back to buffs when closing the inventory.\nFixed controller form focus tooltips being show even when there is no focus.\nFixed smart mining sometimes not selecting the correct tile.\nFixed eraser showing interact box when using controller.\nFixed Steam Deck drawing cursor even when you're not using it.\nPressing tab in preset submission will now go to the next field.\nFixed water and lava buckets sometimes not being consumed correctly when placing it.\nFixed possible crash in multiplayer when checking for player godmode.\nFixed mining speed modifiers not working correctly with the new mining system.\nFixed a couple of other rare possible crashes."));
        patchNotes.add(new GamePatchNotes("Version 0.33.0", "Date: 2025.07.11", "https://store.steampowered.com/news/app/1169040/view/542236932620419111", "===Additions:===\nAdded new Creative Game Mode.\nAdded Eraser tool to Creative Mode.\nAdded the ability to copy and paste blueprints in Creative Mode.\nAdded Pipette bind to controllers.\nAdded CreativeSettings permission tier.\nAdded the ability to upgrade the Carpenters Bench.\nAdded the ability to upgrade the Landscaping Station.\nAdded Tungsten and Fallen Carpenters Bench.\nAdded Tungsten and Fallen Landscaping Station.\nAdded crafting categories for each type of wood in the Carpenters Bench.\nAdded crafting categories for each type of cave biome in the Landscaping Station.\nAdded a recipe for Spoiled Food by adding any Cooked Food in the Compost Bin.\nAdded tooltip for changing to cursor mode on controller.\nAdded Bamboo Trees found in the Deep Swamp Caves.\nAdded Willow Walls, Doors and Windows crafted at the Workstation.\nAdded Bandit Fences and Bandit Fence Gates crafted at the Demonic Workstation.\nAdded Willow Furniture crafted at the Carpenters Bench.\nAdded Dryad Furniture crafted at the Tungsten Carpenters Bench.\nAdded Bamboo Furniture crafted at the Tungsten Carpenters Bench.\nAdded Wooden Candle Set crafted at the Tungsten Carpenters Bench.\nAdded Swamp Candle Stand crafted at the Carpenters Bench.\nAdded Swamp Candle Stand Duo crafted at the Carpenters Bench.\nAdded Brazier crafted at the Tungsten Carpenters Bench.\nAdded Frost Banner and Large Frost Banner crafted at the Carpenters Bench.\nAdded Pirate Banner and Large Pirate Banner crafted at the Carpenters Bench.\nAdded Eggcellent Banner and Large Eggcellent Banner crafted at the Carpenters Bench.\nAdded Dryad Banner and Large Dryad Banner crafted at the Tungsten Carpenters Bench.\nAdded Fishian Banner and Large Fishian Banner crafted at the Tungsten Carpenters Bench.\nAdded Vampiric Banner and Large Vampiric Banner crafted at the Fallen Carpenters Bench.\nAdded Forest Hedges and Hedge Gates crafted at the Landscaping Station.\nAdded Snow Hedges and Hedge Gates crafted at the Landscaping Station.\nAdded Plains Hedges and Hedge Gates crafted at the Landscaping Station.\nAdded Swamp Hedges and Hedge Gates crafted at the Landscaping Station.\nAdded Willow Log Bench crafted at the Landscaping Station.\nAdded Dryad Log Bench crafted at the Tungsten Landscaping Station.\nAdded Bamboo Log Bench crafted at the Tungsten Landscaping Station.\nAdded Stepping Stones and Large Stepping Stone crafted at the Landscaping Station.\nAdded Mossy Stepping Stones and Large Mossy Stepping Stone crafted at the Landscaping Station.\nAdded Goblet and Spilled Goblet crafted at the Landscaping Station.\nAdded Swamp Stone Case crafted at the Landscaping Station.\nAdded Table Clock crafted at the Landscaping Station.\nAdded Dog Plush crafted at the Tungsten Landscaping Station.\nAdded Dino Plush crafted at the Tungsten Landscaping Station.\nAdded Dryad Spirit Cage crafted at the Tungsten Landscaping Station.\nAdded Plate crafted at the Landscaping Station.\nAdded Mug crafted at the Landscaping Station.\nAdded Teapot crafted at the Landscaping Station.\nAdded Dining Set crafted at the Landscaping Station.\nAdded Blue Dining Set crafted at the Landscaping Station.\nAdded Red Dining Set crafted at the Landscaping Station.\nAdded Dirty Plate crafted at the Landscaping Station.\nAdded Dirty Dishes crafted at the Landscaping Station.\nAdded Stew Pot crafted at the Landscaping Station.\nAdded Cutting Board crafted at the Tungsten Landscaping Station.\nAdded Utensil Racks crafted at the Tungsten Landscaping Station.\nAdded Paper Towel crafted at the Tungsten Landscaping Station.\nAdded Paper Stack crafted at the Landscaping Station.\nAdded Green and Pink Books crafted at the Landscaping Station.\nAdded Red Books crafted at the Landscaping Station.\nAdded Blue and Yellow Books crafted at the Landscaping Station.\nAdded Yellow Book crafted at the Landscaping Station.\nAdded Green Book crafted at the Landscaping Station.\nAdded Orange Book crafted at the Landscaping Station.\nAdded Stacked Books crafted at the Landscaping Station.\nAdded Quill and Parchment crafted at the Landscaping Station.\nAdded Observant Mask crafted at the Tungsten Landscaping Station.\nAdded Unamused Mask crafted at the Tungsten Landscaping Station.\nAdded Farseer's Orb crafted at the Tungsten Landscaping Station.\nAdded Fish on a Stick crafted at the Fallen Landscaping Station.\nAdded Void Cube crafted at the Tungsten Landscaping Station.\nAdded Relic of the Depths crafted at the Fallen Landscaping Station.\nAdded Large Globe crafted at the Tungsten Landscaping Station.\nAdded Empty Glass Display crafted at the Landscaping Station.\nAdded Broken Glass Display crafted at the Landscaping Station.\nAdded Beet Glass Display crafted at the Tungsten Landscaping Station.\nAdded Broken Herb Glass Display crafted at the Tungsten Landscaping Station.\nAdded Caveglow Glass Display crafted at the Tungsten Landscaping Station.\nAdded Experimental Root crafted at the Tungsten Landscaping Station.\nAdded Test Tubes crafted at the Tungsten Landscaping Station.\nAdded Void Flask and Test Tube crafted at the Tungsten Landscaping Station.\nAdded Void Flasks crafted at the Tungsten Landscaping Station.\nAdded Blueberry and Corn Extract crafted at the Tungsten Landscaping Station.\nAdded Caveglow Flask crafted at the Tungsten Landscaping Station.\nAdded Stuffed Pig crafted at the Tungsten Landscaping Station.\nAdded Gold Chalice and Spilled Gold Chalice crafted at the Tungsten Landscaping Station.\nAdded Old Plate crafted at the Landscaping Station.\nAdded Rotten Pig Dish crafted at the Landscaping Station.\nAdded Rotten Fish Stew crafted at the Landscaping Station.\nAdded Old Soup crafted at the Landscaping Station.\nAdded Broken Plate crafted at the Landscaping Station.\nAdded Simple Sculpture crafted at the Tungsten Landscaping Station.\nAdded Old Chalices crafted at the Landscaping Station.\nAdded Forgotten Blade crafted at the Landscaping Station.\nAdded Duelist Clock crafted at the Fallen Landscaping Station.\nAdded Half-Eaten Duck crafted at the Tungsten Landscaping Station.\nAdded Roasted Duck crafted at the Tungsten Landscaping Station.\nAdded Leftover Tray crafted at the Tungsten Landscaping Station.\nAdded Picnic Blanket crafted at the Tungsten Landscaping Station.\nAdded Sack crafted at the Landscaping Station.\nAdded Bamboo Debris crafted at the Tungsten Landscaping Station.\nAdded Moss Covered Monk Statue crafted at the Tungsten Landscaping Station.\nAdded Angelic Statue crafted at the Landscaping Station.\nAdded Hooded Knight Statue crafted at the Landscaping Station.\nAdded Tent crafted at the Tungsten Landscaping Station.\nAdded Gargoyle Fountain crafted at the Fallen Landscaping Station.\n\n===Changes/misc:===\nWeapon damage and crit chance tooltip will now both include player modifiers and its enchantment.\nHome Portals from the Portal Flask will now show on the map for the owner and team members.\nMining and placing objects and tiles will now be more consistent when running/placing at high speeds.\nTable decorations can now also be placed on Dinner Tables and Dressers.\nThe Landscaping Station and Carpenters Bench now have a fresh new look.\nDoors now automatically rotate towards adjacent walls similar to fence gates.\nStabby Bush summons now only deals damage on hit (not also on collision).\nSlightly buffed Stabby Bush summons damage and hits they do before they explode.\nDragging items will now show at the cursor when using cursor mode on controllers.\nHides the controller focus highlight when using cursor mode on controllers.\nThe cursor will now jump to the current control focus when using a controller.\nThe controller cursor now acts like a normal cursor, being able to click on all UI with the attack or interact buttons.\nThe game now comes bundled with the controller configurations files instead of relying on the Steam Workshop.\n\n===Fixes:===\nFixed some placeables not getting a speed buff from building speed modifiers.\nFixed Force of Wind attack item sprite not being correct.\nFixed Plains Deep Caves tree saplings having a higher broker value than intended.\nFixed settlers sometimes not able to find complex paths with a lot of doors.\nFixed friendly witches having a recruit dialogue option when it shouldn't.\nFixed summons not following settlers properly when they change their level.\nFixed Crystallized Skull summons not being removed when settlers don't have the item anymore.\nFixed settlers sometimes kept spawning summons when they have no more slots left.\nFixed an interaction between Companion Locket and Dryad Branch that resulted in humongous damage.\n\n===Modding/servers:===\nRenamed giveClientsPower to strictServerAuthority and added a warning about having it enabled."));
        patchNotes.add(new GamePatchNotes("Version 0.32.1", "Date: 2025.04.14", "https://store.steampowered.com/news/app/1169040/view/836088461785040068", "===Changes:===\nAdded recipes for Spirit Urn boss summon item.\nAdded merchant shirt and boots to the stylists shop.\nSpirit Corrupted state in the Plains deep caves will now be active long and have a longer cooldown.\nDryad Sentinels will now start in their hostile state when spawned by Banner of War\nMakes The Soulstorm weapon land its projectile much faster.\nRenamed new trinket found in Deep Plains caves to Spirit Board.\nIncreased the total wealth and wealth gain per day of Pawnbroker.\nBuffed Dryad Barrage damage and adjusted how it uses mana.\nIncreased the max mana Dryad Hat gives.\nUpdated community translations (thanks translators!).\n\n===Fixes:===\nFixed crash when joining a level where TicTacToe has ended in a draw and is fading out.\nFixed possible crash when there is a bit of desync with the new glyph traps.\nFixed possible crash when using the new dryad haunted weapons and there is some desync.\nFixed pawnbroker still getting counted for the Complete Host achievement.\nFixed popup text that appears when using a bow or gun without having ammo.\nFixed magic glyph traps acting on summons and other non-interacting mobs.\nFixed ruby shields not blocking enemy projectiles when not on a team.\nFixed piercing projectiles sometimes counting multiple hits, especially during PvP.\nFixed using item set proxies sometimes not updating armor stats and buffs.\nFixed trader settlers shirt texture when sitting down.\nFixed missing trader settler icon in the settlers help menu.\nFixed hitting priced animals walking out causing angry neutral settlers.\nFixed issue when traders are picking up too many items of the same kind.\nFixed possible crash when talking to a settler and getting and update to their shops current stock.\nFixed not being able to recruit new Trader settler.\nFixed not being able to change look with the Stylist.\nFixed smoke puff particles causing crashes on dedicated servers."));
        patchNotes.add(new GamePatchNotes("Version 0.32.0", "Date: 2025.04.10", "https://store.steampowered.com/news/app/1169040/view/519709875052216962", "===Additions:===\nAdded Plains Deep Caves biome.\nAdded new boss found in Plains Deep Caves.\nAdded The Soulstorm magic weapon dropped from the new boss.\nAdded Spirit Greaves trinket dropped from the new boss.\nAdded Summoner's Bestiary trinket dropped from the new boss.\nAdded Bark Blade melee weapon dropped from the new boss.\nAdded 3 new enemies found in the Plains Deep Caves.\nAdded Amber and Dryad logs found in Plains Deep Caves.\nAdded a full set of Dryad tools crafted at the Tungsten Anvil.\nAdded a full set of Dryad armor crafted at the Tungsten Anvil.\nAdded Dryad Greathammer melee weapon crafted at the Tungsten Anvil.\nAdded Dryad Bow ranged weapon crafted at the Tungsten Anvil.\nAdded Dryad Barrage magic weapon crafted at the Tungsten Anvil.\nAdded Dryad Branch summon weapon crafted at the Tungsten Anvil.\nAdded Dryad walls and doors.\nAdded Parry Buckler shield found in Plains Deep Caves.\nAdded Spirit Board found in Plains Deep Caves.\nAdded Guardian Bracelet found in Plains Deep Caves.\nAdded Second Wind Charm found in Plains Deep Caves.\nAdded Basalt walls, doors, column, coffin and torch.\nAdded Basalt floor, path and pressure plate.\nAdded new Trader settler type that can be recruited and sent on trading missions.\nAdded Mission Board object obtained from quest rewards.\nAdded Shipping Chest object obtained from journal rewards.\nAdded Essence of Rebirth trinket crafted at Tungsten Workstation.\nAdded falling icicle environmental hazard to deep snow caves.\nAdded 3 new and unique traps in the void dungeon.\n\n===Changes/misc:===\nSending people on missions can now be automated with the Mission Board.\nSettler shops now have wealth and limed stock on some items.\nPawnbrokers can now no longer be recruited.\nMiners and Pawnbrokers will now spawn in newly generated NPC villages.\nRenamed Traveling Merchant to Exotic Merchant.\nMage enchants costs are now further reduced by their happiness.\nNPC village settlers will now get angry if you destroy their village.\nNPC villages will now respawn their settlers after a while if they were killed or recruited.\nIncreased Carapace Dagger attack speed and damage slightly.\n\n===Fixes:===\nFixed mini biomes colliding with dungeon entrance, causing them to be cut off.\nFixed zombies in friendly witch cabin disappearing when using nearby ladder.\nFixed being able to dismount in other ways from the Witch Broom when you shouldn't.\nFixed regen debug command not working correctly in some areas.\nFixed settlers sometimes being slow at getting going after having talked to them.\nFixed Slime dome and Star barrier buffs not showing when in water.\nFixed a handful a mobs/treasures not being show in the Adventure Journal.\nFixed a bug where the Butcher's Cleaver would extend food buffs on hit."));
        patchNotes.add(new GamePatchNotes("Version 0.31.1", "Date: 2025.03.06", "https://store.steampowered.com/news/app/1169040/view/534344040319025744", "===Changes:===\nSettlers will now talk to you if they're angry at someone else.\nThe Stylist will now also sell the Elder cosmetic set.\nFixed possible crash when another player was using the new boots on another level.\nFixed being able to cancel netted buff.\nFixed crash when attacking other players with beam weapons.\nFixed possible freeze when a lot of settlers are harvesting/chopping at the same time.\nFixed possible crash when reading Brutes Battleaxe tooltip in item icons.\nFixed melee damage modifier being too high on Runic Helmet.\nFixed Ruby Dragon summons hitting neutral and other mobs when they shouldn't.\nFixed settlers getting knocked down while on a mission making them stuck in that mission.\nFixed rare crash when spawning a raid at very specific settlement loadouts.\nFixed crash when loading an old save with an active raid.\nFixed Runic Boulder and a few other multi tiles place preview.\nFixed the game not launching properly on MacOS.\nFixed Chieftains arena sometimes spawning with missing walls when close to water.\nUpdated community translations (thank you for helping out!)."));
        patchNotes.add(new GamePatchNotes("Version 0.31.0", "Date: 2025.03.05", "https://store.steampowered.com/news/app/1169040/view/534344040319025312", "===Additions:===\nAdded the ability for settlers to use every weapon that the player can.\nAdded new Plains Cave biome.\nAdded new boss in Plains Cave.\nAdded 4 new enemies that spawn in the Plains Caves.\nAdded Sentient Sword summon weapon obtained in Plains Caves.\nAdded Companion Locket trinket obtained in Plains Caves.\nAdded Essence of Perspective trinket obtained in Plains Caves.\nAdded Essence of Prolonging trinket obtained in Plains Caves.\nAdded Will-O'-Wisp Lantern trinket obtained in Plains Caves.\nAdded Runebound Scepter weapon dropped from the new boss.\nAdded Captor's Shortbow weapon dropped from the new boss.\nAdded Brute's Battleaxe weapon dropped from the new boss.\nAdded Hover Boots trinket obtained from Elder Quest rewards.\nAdded Wind Boots trinket obtained in Demonic Workstation.\nAdded Ghost Boots trinket obtained in Tungsten Workstation.\nAdded 11 new Runebound cosmetic armor pieces.\nAdded Challengers Banner obtained from journal rewards.\nAdded mosquito eggs enemy in the deep swamp caves.\nAdded a low chance to spawn a new mini biome on all surface biomes.\nAdded 12 different loadouts of raids that can spawn.\nAdded Revival Potion used to revive knocked down settlers.\nAdded 7 new recipes to the Landscaping Station.\nAdded debug command to enable file logging of debug level log messages.\nAdded batch scripts on Windows to help debug game and gather logs.\nAdded debug_steam_network startup parameter to debug Steam networking.\n\n===Changes/misc:===\nSettlers will now get knocked down instead of dying on classic difficulty and below.\nYou can now no longer shear or milk animals that can be bought.\nSettlement visitors can now no longer be attacked by players part of the settlement.\nReduced the enemy spawn rate slightly on classic difficulty and below.\nReduced the amount of cave cropplers that spawn.\nSettlers AI targeting should now be smarter and more responsive.\nTweaked a bunch of items enchant cost to better match with progression.\nReworked how raid strength is calculated to be based on the items on you and in the settlement.\nReworked raids to be able to use all weapons and armor.\nSettlers max health are now based on the armor they have equipped.\nMoved flower pot into the pots crafting category.\nChanged Snow Deep Cave landscape challenge from craft to obtain.\nLowered resilience gain and attack speed of Carapace Dagger.\nIncreased the glyph size of Sapphire, Amethyst and Emerald staves.\n\n===Fixes:===\nFixed map screenshot tool sometimes crashing game or producing weird images at specific resolutions.\nFixed not being able to use Katanas with controllers.\nFixed Hand Cannon ammo crafting tooltip.\nFixed take elder quest tutorial getting stuck if you already got it.\nFixed crawling zombies spawning when you have Witch set equipped and damage yourself.\nFixed items in crafting guide and enchanting scrolls getting destroyed on server close.\nFixed host form resetting cursor when typing in port.\nFixed being able to place some objects on shores when you shouldn't.\nFixed Banner of War spawning enemies in completed incursions.\nFixed being able to hit yourself with explosions when not on the same level.\nFixed not being able to dig up crystal gravel tiles with a shovel.\nFixed item sets being cleared when assigning new items to a set using controller/steam deck.\nFixed being able to hit targets with explosions when not on the same level.\nFixed projectiles not triggering their on hit logic when it hits other players than yourself.\nFixed resource packs with hair and body textures not being correctly loaded.\nFixed HDR issues with some monitors not disabling it when closing the game by adding a workaround.\nFixed not being able to aim far with controllers when using Blink Scepter.\nFixed text being cut off in the beginning in zone config menus.\nFixed cursor not becoming active on crash windows with the Steam deck.\nFixed decorative flowers and pots not dropping when being replaced.\nFixed incursion progress bar hidden when \"Show boss health bar\" setting disabled.\nFixed spawning on a double-tile rock only removing one side of it.\n\n===Modding/servers:===\nTiles, objects and tool items tool tier is now a float."));
        patchNotes.add(new GamePatchNotes("Version 0.30.0", "Date: 2025.01.23", "https://store.steampowered.com/news/app/1169040/view/521955337470738713", "===Additions:===\nAdded frozen groups of enemies that spawn in snow caves.\nAdded quicksand pools to desert caves.\nAdded swamp spores and poison clouds to swamp caves.\nAdded Cave Croppler critter to caves.\nAdded Beet crop and 2 new food recipes.\nAdded Sapphire Staff buff weapon crafted in Iron Anvil.\nAdded Amethyst Staff buff weapon crafted in Demonic Anvil.\nAdded Emerald Staff buff weapon crafted in Tungsten Anvil.\nAdded Ruby Staff buff weapon crafted in Tungsten Anvil.\nAdded gravel and sandstone gravel tile recipes to the workstation.\nAdded crystal gravel tile recipes to the landscaping station.\nAdded dash ability to the Hoverboard.\n\n===Changes/misc:===\nIncreased the max speed of the Hoverboard slightly.\nDecreased the max speed of Witch Broom slightly.\nBuffed miners stew and made it require beets.\nSmall crystal clusters now occasionally drop their respective gems.\nTweaked volume of small crystal cluster sounds.\nIncreased Sapphire Revolver damage and attack speed.\n\n===Fixes:===\nFixed bombs not exploding if you change your level after having thrown them.\nFixed removing objects on tiles with other multi tile objects sometimes making stuff disappear.\nFixed swamp stone path one tile vertical texture.\nFixed removing logic gates not clearing their output to wires.\nFixed storage config low/lower and high/higher names being swapped.\nFixed incursion portals sometimes not rendering when placed on top of carpets."));
        patchNotes.add(new GamePatchNotes("Version 0.29.0", "Date: 2024.12.19", "https://store.steampowered.com/news/app/1169040/view/519700372313342178", "===Additions:===\nAdded Suspiciously Tall Goblin enemy to forest cave loot areas.\nAdded witch cabin with a Friendly Witch on the Swamp surface.\nAdded Witch castle that spawns in the Swamp caves.\nAdded 3 Evil Witch mini bosses in the Swamp caves.\nAdded a cozy cottage that can spawn on all surface biomes.\nAdded a low chance to spawn a Christmas House in the snow surface biome.\nAdded full Witch armor set.\nAdded Necrotic Flask magic weapon.\nAdded Necrotic Greatsword melee weapon.\nAdded Necrotic Bow summon weapon.\nAdded Necrotic Soul Skull trinket.\nAdded Rolling Pin boomerang weapon.\nAdded Butcher's Cleaver boomerang weapon.\nAdded Witch Broom mount.\nAdded 23 new potted decorations crafted in Carpentry Bench.\nAdded double beds for all furniture types.\nAdded windows for all wall variants.\nAdded Fishian Hook Warrior enemy.\nAdded Fishian Healer enemy.\nAdded Static Jellyfish enemy.\nAdded Fishian mini biome to Deep Swamp Caves.\nAdded Anchor & Chain melee weapon found in Deep Swamp Caves.\nAdded Bamboo walls and floors.\nAdded Bone furniture set.\nAdded overgrown grass to both forest and swamp.\nAdded Necesse on strings as vinyls.\nAdded vinyls section for biomes in the Adventure Journal.\n\n===Changes/misc:===\nItems destroyed by settlers will now have a slight pickup delay.\nSettlers will now wander away when they've finished a task.\nRenamed dynamic zoom and interface size settings to better explain what they do.\nImproved initial loading time by approximately 30%.\nReduced memory usage by approximately 40%.\nWorld map and travel scrolls can now be used from trial rooms and incursions.\nChanged the AI behaviour of goblins, making them run randomly around more.\nIncreased sensor gate detection range to up to 15 tiles away.\nZombie archers will now charge up their bow before attacking.\nCollision chasers will now no longer keep running into you after having attacked you.\nMiners found in the caves will now emit a bit of light.\nMost enemies will now have a chance to move a bit after having attacked.\nFlesh particles now bounce and rotate a bit more.\nWorm enemy types are now slightly more resistant toward damage over time.\nFlower patches will now spread if placed by the player.\nMoved carpets and paintings under a decorations sub category.\nUpdated presets around the world with new furniture, windows and decorations.\nLifeline will now also prevent death from damage over time.\nChef's Special can now be crafted at the Tungsten Anvil.\nAll vinyls now have a tooltip showing where the music is from.\nSeveral surface mini biomes can now spawn in more different biomes.\nOld vinyls loot are now split up in their biomes.\nThe starter chests in the elder's house now also contains 5 health potions.\n\n===Fixes:===\nFixed some presets generating with multiple paintings and carpets on one tile.\nFixed boomerangs and other melee projectile weapons generating with ranged enchants.\nFixed craft 10 hotkey not working properly in new workstations.\nFixed missing shadow on Void Apprentices.\nFixed some pet items not counting toward the get pet achievement.\nFixed issue with sensor gate sometimes detecting wrong based on where it was placed.\nFixed maple and birch beds not covering sleepers."));
        patchNotes.add(new GamePatchNotes("Version 0.28.1", "Date: 2024.11.02", "https://store.steampowered.com/news/app/1169040/view/4474982295507304682", "===Changes:===\nChanged Tungsten Anvil recipe to use Quartz instead of Obsidian.\nFixes crash when using a Sickle.\nFixed not being able to edit some text boxes using controller.\nUpdated community translations."));
        patchNotes.add(new GamePatchNotes("Version 0.28.0", "Date: 2024.11.01", "https://store.steampowered.com/news/app/1169040/view/4474982295507304642", "===Additions:===\nAdded candles that can be placed on the ground.\nAdded craft 10 key modifier control that overrides craft all by default.\nAdded the ability to upgrade workstations instead of crafting a new one.\nAdded demonic, tungsten and fallen anvils.\nAdded void and caveglow alchemy tables.\nAdded homestone, waystone and settlement flag icons to island map.\nAdded raspberry bush sapling to farmer shop post Pirate Captain.\nAdded work range overlay when hovering over priority to minimap as well as the game scene.\nAdded Adventure journal challenges.\nAdded Banner of Peace as a journal challenge reward.\nAdded Banner of War as a journal challenge reward.\nAdded Travelstone as a journal challenge reward.\nAdded Miners Prosthetic trinket as a journal challenge reward.\nAdded Seed Gun and Seed Pouch as journal challenge reward.\nAdded Seahorse mount as journal challenge reward.\nAdded fishing hut and broken fence preset that generate on spawn islands.\nAdded flower patches to forest, plains, snow and swamp biomes.\nAdded tree stumps and fallen logs to forest and swamp biomes.\nAdded tree roots clutter to swamp biomes.\nAdded cow skeleton clutter to desert biomes.\nAdded night soundtrack to plains biome.\n\n===Changes/misc:===\nCarpets can now be placed under other objects.\nPainting can now be placed on walls behind other objects.\nRemoved wall torches, wall lanterns and wall candles recipes.\nTorches and candles can now be placed on fences, tables and walls.\nReworked crafting station UI, adding categories, easier searching and highlights.\nChanged Advanced Workstation to Tungsten Workstation.\nReworked regular Workstation and Demonic Workstation to take up a 2x1 space.\nTweaked some of crafting station textures.\nReworked where a bunch of recipes appear and sorted them to be more intuitive.\nLowered the initial settlement recipe \"craft until\" count for items.\nIncreased the durability of waystones before breaking.\nNew items picked up into pouches will now highlight the pouch.\nNew items in inventory are now more visible with a green slot.\nRemoved the regular Elder quests, replacing them with journal challenges.\nElder quest rewards and journal challenges can now be bought again from the Elder himself.\nThe adventure journal will now remember what you had open.\nThe starting elder house is now randomly selected between 7 different presets.\nChanged the wording of quickstack button tooltips.\nObjects can now be placed on paths right next to water as well.\nThe tutorial has been slightly updated to include adventure journal and Elder quests.\n\n===Fixes:===\nFixed game attempting to load known invalid save files.\nFixed sunflowers not generating in the new plains biome.\nFixed armor, wigs, shirt and shoe items combining on dropped when they shouldn't.\nFixed mages not selling correct homestone and waystones when out on adventure parties.\nFixed roped mobs not snapping when teleporting to the roper.\nFixed mapshots sometimes causes crashes or corrupt images.\nFixed hunters spawning in cabins in the forest not being able to be recruited from the start.\n\n===Modding/servers:===\nThere are now several object layers with only the base one supporting collision and object entities."));
        patchNotes.add(new GamePatchNotes("Version 0.27.0", "Date: 2024.09.27", "https://store.steampowered.com/news/app/1169040/view/4701285005731315638", "===Additions:===\nAdded new plains surface biome and village.\nAdded Raspberry Bush.\nAdded Birch Tree and birch furniture set.\nAdded Maple Tree and maple furniture set.\nAdded cracks to most tiles and objects when they're being broken.\nAdded 25 new painting objects throughout the game.\nAdded 9 new carpets to the carpenters bench.\nAdded water lantern to the carpenters bench.\nAdded fountain to the landscaping station.\nAdded broken painting to the landscaping station.\nAdded Chicken and Rooster husbandry animals.\nAdded Ram husbandry animal.\nAdded Bull husbandry animal.\nAdded Boar husbandry animal.\nAdded the ability to choose desired female/male to husbandry zone when slaughtering.\nAdded Eggs, Chicken Meat and Raspberry food ingredients.\nAdded 14 new food items and recipes.\nThe Evil's Protector now has a low chance to drop an Eye in a Portal.\nAdded a chance to spawn a new structure in the forest surface biome.\nAdded Grizzly bears to forest caves.\nAdded a secret area to the temple biome.\nAdded a secret area to the desert caves.\nAdded small water streams with bridges to regular caves.\nAdded Stylish Flower head cosmetic to Stylist settlers.\nAdded new and improved wire textures.\nAdded open adventure journal control hotkey.\nAdded 10 slots for playlist and controls to portable vinyl player.\nAdded 2 new music tracks.\n\n===Changes/misc:===\nVillages now have carpets and paintings.\nAnimals in villages will now have to be bought if you want to bring them to your own island.\nKilling animals in NPC villages will now make the villagers angry.\nImported animal items are now no longer sold by merchants and can no longer be obtained.\nTraveling Merchant can now spawn with animals they sell.\nTraveling Merchant will now also sell a random large painting.\nA lot of items now have a larger stack size, such as logs, ores and tiles.\nStabby Bush mob will now no longer attack your settlers unprovoked.\nStabby Bush mob and summons now explode after fewer hits and the explosion deals less damage.\nStabby bush mob and summons attack and movement speed per frenzy stack has been slightly reduced.\nPirate Captain boss will now look like the settler he becomes when defeated.\nBanners now look cooler.\nWater in caves will now become deeper much faster.\nHome portals will now try to spawn a bit away from other portals.\nIncreased range on explosives slightly, but decreased damage done to objects and tiles at the edge.\n\n===Controller:===\nController control tips will now no longer show if control tips are turned off in interface settings.\n\n===Fixes:===\nFixed banners not showing when using some specific helmets.\nFixed not being able to see hair color selection when having the bald hairstyle selected.\nFixed high attack speed weapons hitting an attack speed limit because of game tick rate.\nFixed not showing shields when using it and holding a banner at the same time.\nFixed explosive modifier dealing a bit too much damage, especially when crawlmageddon zombies would explode.\nFixed settlers getting their orders cleared when sent on a mission/expedition.\nFixed Deep Sandstone Rock Ancient Fossil Ore recipe.\nFixed Stabby Bush death messages not saying what the victim was.\nFixed some items being a bit blurry in inventory slots.\nFixed Crystal Dragon not having a chance to drop its vinyl.\nFixed tracked quests data getting lost when backing up worlds.\nFixed shadow on some sapling items.\n\n===Modding/servers:===\nUpgraded to LWJGL version 3.3.2."));
        patchNotes.add(new GamePatchNotes("Version 0.26.1", "Date: 2024.08.16", "https://store.steampowered.com/news/app/1169040/view/6780818423219274449", "===Changes:===\nAdded restart button instead of quit when available after changing active mods.\nAdded the ability to change your settlers looks when talking to your stylist.\nTraveling merchants now also show on the minimap.\nVisiting settlers will always show a ? over their head and on the mini map.\nQuest markers and notices on settlers and visitors now show on the minimap as well.\nBlood Grimoire now no longer heal on training dummies if a boss is nearby.\nEnemies killed by only adventure party members will now also count toward a kill for the player.\nMade Emerald Wand projectiles home in on targets after projectiles slow down.\nChanged mushroom sprites to be slightly more visible when planted on farmland.\nCarpets are now significantly cheaper to craft.\nChanged item sprites of bait.\nRemoved head from pirate recruit debris particles.\nAdjust enchant cost for all tier 1 and above weapons.\nFixed being able to cancel Katana stacks.\nFixed sorting causing spoil timers to not merge correctly.\nFixes settlers sometimes getting stuck in chairs/beds if the game was force closed.\nFixed Blood Grimoire secondary damage ticking too often when shooting at a lot of targets.\nFixed new achievements not getting loaded correctly from Steam if completed on another computer.\nFixed adventure party members not using potions and recall scrolls when the player has died.\nFixed rare potential crash related to using objects and rendering them at the same time.\nFixes Venom Slasher projectiles not gaining resilience on hit.\nFixes random enchantments being able to give an enchanted item the same enchantment.\nFixes small Crystal Clusters not making sounds when broken.\nFixes Cabbage item sprite having a shadow.\nFixed Night Steel set not cancelling channelling attacks."));
        patchNotes.add(new GamePatchNotes("Version 0.26.0", "Date: 2024.08.10", "https://store.steampowered.com/news/app/1169040/view/4352250961656694552", "===Additions:===\nAdded 16 new achievements.\nAdded smooth lighting to rocks and walls.\nAdded wind effects.\nAdded the ability to sit on chairs and benches.\nAdded deeper and shallow parts of water.\nAdded screenshot tool to island map.\nAdded 20 new hairstyles you can select during character creation and Stylist change.\nAdded 12 new eye types you can select during character creation and Stylist change.\nAdded 8 new beard types you can select during character creation and Stylist change.\nAdded expression wheel, by default used by holding down T.\nAdded the ability to restore controls to their default key bind.\nAdded toggle in pouches to disable auto pickup.\nAdded Hardhat cosmetic item bought from the Blacksmith.\nAdded Captains Boots cosmetic item bought from Stylist.\nAdded Pirate Eyepatch cosmetic item bought from Stylist.\nAdded Pirate Bandana with Eyepatch cosmetic item bought from Stylist.\nAdded the option to buy settler cosmetic gear from each settler or Stylist.\nAdded the Stabby Bush found creeping in the wilds.\nAdded Landscaping Station crafted at Advanced Workstation.\nAdded recipes for a ton of different rocks and other objects to the Landscaping Station.\nAdded the ability to change skin and eyes at the Stylist at the cost of void shards.\nAdded 2 new boss soundtracks for Sage and Grit and the Cryo Queen.\n\n===Changes/misc:===\nReworked over 3200 assets in the game to match new graphics style.\nReworked how water is rendered, making depth gradual.\nReworked controls settings ui.\nReworked host world ui.\nTweaked health, mana, resilience and hunger bars.\nSettlers can now spawn with different genders, hairstyles, skin colors, etc.\nSettlers will now sit down on chairs/benches to eat if possible.\nSettlers will now sit down on chairs/benches to shorten their work break.\nTweaked some settlers default cosmetics.\nChanged shader used for scaling to make pixels less blurry when zoomed in.\nSettlers will now walk around holding the items they are hauling.\nIncreased the interval between settlers update their mood icons.\nMade settler full inventory only show when it is important.\nFences now connect to cave rocks.\nHair is now being shown under many hats and helmets in the game.\nJournal button will now blink when a new entry is available.\nTalking to the elder will now go straight into quests if you can complete it.\nSettlers exiting beds will now not exit in cramped spaces and get stuck.\nReworked the character creator and stylist interface.\nStylist can now change your skin color and eyes as well at the cost of void shards.\nSettlers can now use banners if you manually give them one.\nBanner stands will now buff all settlers within range as well.\nMade Strike Banners obtainable, randomly found in village chests.\nFlowers can now be placed in the wild as decoration.\nZephyr Boots now no longer disables Zephyr Charm trinket.\nMade the start shirt and shoes colors less limited.\nUpdated all colors of the objects and tiles on the minimap to match the new art style.\n\n===Fixes:===\nFixed sometimes not being able to place objects near sleeping settlers\nFixed crash when trying to run specific commands.\nFixed too many tooltips shown when having compressed worlds in the world loading menu.\nFixed Windows sometimes deciding not to use the dedicated graphics card if one is available.\nFixed restoring backups wiping some world data, like adventure party settlers.\nFixed worlds running in the background while you are selecting or creating your character.\nFixed ambient lighting sometimes flickering for one second when using non-standard day time modifiers.\n\n===Modding/servers:===\nMade mod patches logging more robust.\nAdded a bunch of illegal mod patches that the game will ignore around crashes and mod conflicts.\nChanged significant parts of window, graphics and sound systems.\nAdded more launch options, which you can see by using the -help launch option."));
        patchNotes.add(new GamePatchNotes("Version 0.25.1", "Date: 2024.05.30", "https://store.steampowered.com/news/app/1169040/view/4158590470400903503", "===Changes:===\nIncreased damage of Katana weapons.\nIncreased damage of Crystallized Skull summon weapon.\nRemoved the moving sound by Ruby Dragons.\nRuby Crown now also grants +1 max summons.\nAdded recipe for Crystal Bullets to Fallen Workstation.\nMade trinket slot and item set increase items also mark previous ones as obtained.\nMade crystal mini biomes have much higher chance to spawn the big crystals that drop materials.\nChanged Crystal Golem attack to have an indicator, stand still and different sound.\nIncreases the entrance area in Crystal Hollow incursions.\nMining expeditions for the correct ores now also have a chance to retrieve crystals.\nAdded settlements admin chat command.\nUpdated community translations (thank you translators!).\nFixed settler moods being shown while they are on a mission.\nFixed Steam still showing you playing singleplayer when you're hosting your world.\nFixed fatal crash when hosting and going back to the main menu later.\nFixed development mod not loading first if another mod with the same identifier exists.\nFixed crash when attempting to load mods that are not the correct structure.\nFixed crash when trying to open item actions on an empty slot for controllers.\nFixed crash when entering levels that are not part of the journal.\nFixed color picker being completely black.\nFixed deleting characters not working.\nFixed adventure journal loot not displaying names that are too long correctly.\nFixed Intel driver crashes for real this time.\nFixed streetlamps still providing light when turned off.\nFixed crash when trying to run specific commands.\nFixed window selection in borderless and windowed mode not working on linux.\nFixed Ravenlord set bonus not showing the correct damage.\nFixed some characters getting compressed together in some languages.\nFixed being able to dupe items while dead."));
        patchNotes.add(new GamePatchNotes("Version 0.25.0", "Date: 2024.05.27", "https://store.steampowered.com/news/app/1169040/view/4168722935774123865", "===Additions:===\nAdded ability to have different equipment item sets.\nAdded Crystal Hollow incursion.\nAdded 4 different crystal mini-biomes.\nAdded 4 crystal themed weapons crafted at the Fallen Workstation.\nAdded 2 crystal themed weapons crafted at Advanced Workstation.\nAdded 2 crystal themed weapons crafted at Demonic Workstation.\nAdded Demon Cloak that increases max item sets dropped by Evils Protector.\nAdded Arcane Armory that increases max item sets crafted at Demonic Workstation.\nAdded Abyssal Cloak that increases max item sets dropped by Fallen Wizard.\nAdded Adventure Journal to keep track of all the monsters and loot you may encounter on your journey.\nAdded Katana found somewhere on the surface.\nAdded Reinforced Katana crated at Advanced Workstation.\nAdded Chef's Special weapon obtained as random incursion reward.\nAdded Ravenbeak Spear weapon obtained as random incursion reward.\nAdded Kinetic Boots trinket obtained as random incursion reward.\nAdded Storming unique incursion modifier.\nAdded settlement notifications showing potential problems and how to fix them.\nAdded flashing icons above settlers showing if they are hungry, have a full inventory or missing a bed.\nAdded hotkey for quick dropping items.\nAdded hotkeys for changing item sets.\nAdded X and Reddit buttons to main menu.\nAdded patch notes button to main menu.\nAdded a new soundtrack for the Reaper boss fight.\nAdded a new soundtrack for the Desert Temple.\n\n===Changes/misc:===\nIncursions now also drop alchemy and upgrade shards on completion.\nThe frenzy modifier speed effect is now halved on bosses.\nThe Ravenlord Sets movement speed and critical damage increase has been slightly reduced.\nThe Dawn and Dusk set has been added to the Incursion Modifier reward pool.\nSettlement boss quests will now show their reward and hand-in tip.\nYou will now automatically get the boss quest for the settlement when you defeat the boss.\nIncreased the max crafts settlers can do at a time in the Cheese Press, Compost Bin and Grain Mill.\nOptimized settler storage sorting significantly.\n\n===Fixes:===\nFixed some of the moon and sun incursion tiles not showing in the item list.\nFixed character playtime going up while in character select or creation screen.\nFixed not being able to select the same character but a newer version on servers that enabled outside characters again.\nFixed Alchemical Interference incursion modifier debuff, sometimes not being removed.\nFixed some Intel integrated graphics causing random hard crashes."));
        patchNotes.add(new GamePatchNotes("Version 0.24.2", "Date: 2024.03.27", "https://steamcommunity.com/games/1169040/announcements/detail/4166466062430885696", "===Changes:===\nAdded a small random gimmick that will be active on April 1st.\nOptimized settlement job ticking for hauling fuel.\nUpdated community translations (thank you translators!).\nFixed crafted Orb of Slimes not being tier 1.\nFixed spoil time showing in processing stations with spoiling disabled.\nFixed Mycelium Pickaxe dropped texture being offset.\nFixed island map size being messed up when changing resolution.\nFixed flame and spike traps being able to hit players on other levels.\nAnd a few other smaller fixes."));
        patchNotes.add(new GamePatchNotes("Version 0.24.1", "Date: 2024.03.20", "https://steamcommunity.com/games/1169040/announcements/detail/4103415032706288014", "===Additions:===\nAdded recipes for Dawn and Dusk doors.\nAdded Streetlamps crafted in Anvil and advanced Workstation.\nAdded Lanterns crafted in Anvil and advanced Workstation.\nAdded Wall Candles crafted in Carpenters Bench.\nAdded Candle Pedestals crafted in Carpenters Bench.\nAdded Tiki Torches crafted in Workstation.\nAdded vinyl drops to the 3 newest bosses.\nAdded stone as a reward the Miner settlers mining trips.\nAdded recipes for tier 1 gateway tablets to Fallen Workstation.\n\n===Changes/misc:===\nTools can now also be upgraded in the upgrade station.\nAdjusted all weapons upgrading from base to tier 2 or higher.\nUpgraded tools has been added to the incursion reward pool.\nSet bonuses changes now show properly in upgrade station.\nAll deep cave bosses now have slightly different stats in incursions.\nIncursion modifiers are now removed when an incursion has been completed.\nFallen Workstation recipe has been updated to cost alchemy and upgrade shards to craft.\nGateway tablets are now sorted by tier first, then their name.\nItems that summon bosses can no longer be used in Incursions.\nRewards from Incursions should now be displayed more clearly.\nDawn and Dusk armor pieces now drop as personal loot for all players in the Incursion.\nDawn and Dusk individual armor pieces now rotate per boss kill.\nItem sell price is now affected by item tier level.\nItem enchant price is now affected by item tier level.\nFire Chalices, Magic Stilts and Shine Belt now provide more light.\nSunlight Champion explosion event is now more obvious and has less range.\nChests and other inventories in settlements are now immune to explosive damage.\nItems now incinerate at different rates.\nRemoved the last row of pressure plates in maze trials.\nUpdated submitted community translations (thank you translators!)\n\n===Fixes:===\nFixed new items in updates being allowed in chest filters.\nFixed Dawn and Dusk armors not set as obtainable.\nFixed Dawn and Dusk armors causing crash on armor stands and settlers.\nFixed Dawn and Dusk armors not changing appearance on settlers and armor stands.\nFixed Dusk armor set summons not damaging correctly.\nFixed flamelings possible crash on dedicated servers.\nFixed upgrade shards not spawning in spider castle incursion\nFixed wrong alchemy shard rocks spawning in spider castle incursion\nFixed moon arena boss darkness buff being applied to everyone on the server.\nFixed Death particles not showing for Sunlight Champion and Moonlight Dancer.\nFixed Resilience being completely drained when max resilience decreases.\nFixed Sunlight Champion's swirls not being visible on low particle settings.\nFixed Sunlight Champion's swirls sometimes causing crashes when leaving levels.\nFixed ravenlord set crashing on dedicated servers when a player with the set equipped left the server.\nFixed sunlight champion possible crash on dedicated servers.\nFixed some upgrade stats showing double plus signs.\nFixed an issue where if you left a server in an incursion you could end up outside the level.\nFixed melee summons not being able to attack training dummies.\nFixed Sage & Grit and Pest Warden sometimes dropping their loot in strange locations.\nFixed summons not teleporting with the player if the player got kicked out of an incursion due to it closing.\nFixed possible crash when placing down a logic gate."));
        patchNotes.add(new GamePatchNotes("Version 0.24.0", "Date: 2024.03.04", "https://steamcommunity.com/games/1169040/announcements/detail/4111294434908390398", "===Additions:===\nAdded 2 new bosses to unique incursions.\nAdded functionality to upgrade station.\nAdded salvage station crafted at Fallen Workstation.\nAdded a bunch of unique modifiers and effects to incursions on top of area modifiers.\nAdded Fools Gambit trinket sold by Traveling Merchant after Pirate Captain.\nAdded Dusk armor set obtained through incursions.\nAdded Dawn armor set obtained through incursions.\nAdded Ravenlord armor set obtained through incursions.\nAdded The Raven's Nest greatbow obtained through incursions.\nAdded Ravenwing Greatsword obtained through incursions.\nAdded brightness slider to graphics settings.\nAdded 4 new original music tracks.\n\n===Changes/misc:===\nRebalanced and added upgraded stats to all weapons and armor.\nReworked gateway tablets to be consumed for each open incursion.\nReworked incursion loot to give upgraded items and other gateway tablets.\nReworked incursion modifiers to scale with tier instead of being random.\nRebalanced all deep cave mob stats inside incursions.\nChanged pressure plate maze trial room to be more intuitive.\nExtraction incursions now only spawn mobs as you progress in the incursion.\nGateway tablets now drop randomly inside incursions.\nCarapace Shield will now also work for damage coming in all directions.\nIslands now have a small chance to generate as a circle like in older version.\nIncreased initial allocated memory on Windows and Mac.\n\n===Fixes:===\nFixed being able to use cutter and wrench on protected levels.\nFixed GrindTheAlarm vinyl never generating.\nFixed teammate markers not showing up correctly when changing levels.\nFixed stamina getting stuck when changing to a world that is behind in time.\nFixed Bloodplate set buff occasionally desyncing."));
    }
}

