/*
 * Decompiled with CFR 0.152.
 */
package necesse.entity.mobs.friendly.critters.flyingbugs;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import necesse.engine.GameTileRange;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.MobRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.sound.SoundSettings;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobSpawnLocation;
import necesse.entity.mobs.MobTexture;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.HomesickCritterAI;
import necesse.entity.mobs.friendly.critters.flyingbugs.SmallFlyingBugCritterMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.item.Item;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.MobChance;
import necesse.level.maps.light.GameLight;

public class FireflyMob
extends SmallFlyingBugCritterMob {
    public static MobChance spawnChanceSurface = new MobChance(250){

        @Override
        public boolean canSpawn(Level level, ServerClient client, Point spawnTile, String purpose) {
            if (!purpose.equals("mobspawning")) {
                return false;
            }
            if (!level.getWorldEntity().isNight()) {
                return false;
            }
            return level.entityManager.mobs.streamInRegionsInTileRange(spawnTile.x * 32 + 16, spawnTile.y * 32 + 16, FireflyMob.fireflyRange.maxRange).noneMatch(m -> GameMath.diagonalMoveDistance(m.getX(), m.getY(), spawnTile.x * 32 + 16, spawnTile.y * 32 + 16) < (double)(FireflyMob.fireflyRange.maxRange * 32));
        }

        @Override
        public Mob getMob(Level level, ServerClient client, Point spawnTile) {
            return null;
        }

        @Override
        public Collection<Mob> spawnMob(Level level, ServerClient client, Point spawnTile, Predicate<Mob> beforeTest, Consumer<Mob> beforeAdded, String purpose) {
            ArrayList<Mob> spawnedMobs = FireflyMob.getFirefliesToSpawn(level, client, spawnTile.x, spawnTile.y, 0.3f, beforeTest);
            if (spawnedMobs.isEmpty()) {
                return null;
            }
            while (spawnedMobs.size() > 8) {
                spawnedMobs.remove(GameRandom.globalRandom.nextInt(spawnedMobs.size()));
            }
            for (Mob mob : spawnedMobs) {
                if (beforeAdded != null) {
                    beforeAdded.accept(mob);
                }
                level.entityManager.mobs.add(mob);
            }
            return spawnedMobs;
        }
    };
    public static MobChance spawnChanceCave = new MobChance(40){

        @Override
        public boolean canSpawn(Level level, ServerClient client, Point spawnTile, String purpose) {
            if (!purpose.equals("mobspawning")) {
                return false;
            }
            return level.entityManager.mobs.streamInRegionsInTileRange(spawnTile.x * 32 + 16, spawnTile.y * 32 + 16, FireflyMob.fireflyRange.maxRange).noneMatch(m -> GameMath.diagonalMoveDistance(m.getX(), m.getY(), spawnTile.x * 32 + 16, spawnTile.y * 32 + 16) < (double)(FireflyMob.fireflyRange.maxRange * 32));
        }

        @Override
        public Mob getMob(Level level, ServerClient client, Point spawnTile) {
            return null;
        }

        @Override
        public Collection<Mob> spawnMob(Level level, ServerClient client, Point spawnTile, Predicate<Mob> beforeTest, Consumer<Mob> beforeAdded, String purpose) {
            ArrayList<Mob> spawnedMobs = FireflyMob.getFirefliesToSpawn(level, client, spawnTile.x, spawnTile.y, 0.3f, beforeTest);
            if (spawnedMobs.isEmpty()) {
                return null;
            }
            while (spawnedMobs.size() > 5) {
                spawnedMobs.remove(GameRandom.globalRandom.nextInt(spawnedMobs.size()));
            }
            for (Mob mob : spawnedMobs) {
                if (beforeAdded != null) {
                    beforeAdded.accept(mob);
                }
                level.entityManager.mobs.add(mob);
            }
            return spawnedMobs;
        }
    };
    public static GameTileRange fireflyRange = new GameTileRange(3, new Point[0]);
    protected FireflyType fireflyType;
    protected boolean overrideFireflyType;
    public static final int lightEmissionLevel = 40;
    public static final int drawLightLevel = 120;
    protected float lightStrength;

    public static ArrayList<Mob> getFirefliesToSpawn(Level level, ServerClient client, int tileX, int tileY, float spawnChance, Predicate<Mob> beforeTest) {
        ArrayList<Mob> spawnedMobs = new ArrayList<Mob>();
        int spawnRoomID = level.regionManager.getRoomIDByTile(tileX, tileY);
        for (Point validTile : fireflyRange.getValidTiles(tileX, tileY)) {
            if (!GameRandom.globalRandom.getChance(spawnChance) || level.isSolidTile(validTile.x, validTile.y) || spawnRoomID != level.regionManager.getRoomIDByTile(validTile.x, validTile.y)) continue;
            Mob mob = MobRegistry.getMob("firefly", level);
            if (beforeTest != null && !beforeTest.test(mob)) continue;
            Point moveOffset = mob.getPathMoveOffset();
            if (!mob.isValidSpawnLocation(level.getServer(), client, validTile.x * 32 + moveOffset.x, validTile.y * 32 + moveOffset.y)) continue;
            mob.onSpawned(validTile.x * 32 + moveOffset.x, validTile.y * 32 + moveOffset.y);
            spawnedMobs.add(mob);
        }
        return spawnedMobs;
    }

    public FireflyMob() {
        this(FireflyType.YELLOW, true);
    }

    public FireflyMob(FireflyType fireflyType) {
        this(fireflyType, false);
    }

    public FireflyMob(FireflyType fireflyType, boolean overrideFireflyType) {
        super(2);
        this.fireflyType = fireflyType;
        this.overrideFireflyType = overrideFireflyType;
    }

    @Override
    public void applyLoadData(LoadData save) {
        if (save.hasLoadDataByName("fireflyType")) {
            this.fireflyType = save.getEnum(FireflyType.class, "fireflyType");
            this.overrideFireflyType = false;
        }
        super.applyLoadData(save);
    }

    @Override
    public void addSaveData(SaveData save) {
        if (!this.overrideFireflyType) {
            save.addEnum("fireflyType", this.fireflyType);
        }
        super.addSaveData(save);
    }

    @Override
    public LootTable getLootTable() {
        String itemStringID = this.fireflyType == null ? FireflyType.YELLOW.droppedItemStringID : this.fireflyType.droppedItemStringID;
        return new LootTable(new LootItem(itemStringID));
    }

    @Override
    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextEnum(this.fireflyType);
    }

    @Override
    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.fireflyType = reader.getNextEnum(FireflyType.class);
    }

    @Override
    protected MobTexture getBugTexture() {
        return MobRegistry.Textures.firefly;
    }

    @Override
    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI<FireflyMob>(this, new HomesickCritterAI(this));
        if (this.isClient()) {
            return;
        }
        if (!this.overrideFireflyType) {
            return;
        }
        if (!this.getLevel().getIdentifier().equals(LevelIdentifier.SURFACE_IDENTIFIER)) {
            this.fireflyType = this.getLevel().getIdentifier().equals(LevelIdentifier.CAVE_IDENTIFIER) ? FireflyType.GREEN : FireflyType.BLUE;
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, this.fireflyType.emissionHue, 1.0f, this.fireflyType.emissionLevel);
        this.lightStrength = FireflyMob.getLightStrength(this.getLevel(), FireflyMob.getTileCoordinate(this.x), FireflyMob.getTileCoordinate(this.y));
        if (this.lightStrength > 0.7f) {
            if (this.dx != 0.0f || this.dy != 0.0f) {
                if (this.getLevel().tickManager().isGameTickInSecond(10) || GameRandom.globalRandom.getChance(0.03f * this.lightStrength)) {
                    this.spawnGlowParticle();
                }
            } else if (this.getLevel().tickManager().isGameTickInSecond(14) || GameRandom.globalRandom.getChance(0.02f * this.lightStrength)) {
                this.spawnGlowParticle();
            }
        }
    }

    @Override
    public float getDespawnOdds() {
        if (!this.getWorldEntity().isNight()) {
            return super.getDespawnOdds() * 5.0f;
        }
        return super.getDespawnOdds();
    }

    public static float getLightStrength(Level level, int tileX, int tileY) {
        GameLight light = new GameLight(level.lightManager.getAmbientLight());
        return GameMath.limit(1.0f - (light.getLevel() - 50.0f) / 50.0f, 0.0f, 1.0f);
    }

    public static Color getFireflyGlowColor(FireflyType type, float lightStrength) {
        Color glowColor = type.glowColor;
        float colorFactor = GameMath.limit(lightStrength, 0.4f, 1.0f);
        return new Color(GameMath.limit((int)((float)glowColor.getRed() * colorFactor), 0, 255), GameMath.limit((int)((float)glowColor.getGreen() * colorFactor), 0, 255), GameMath.limit((int)((float)glowColor.getBlue() * colorFactor), 0, 255), 255);
    }

    protected void spawnGlowParticle() {
        int emissionLevel = (int)(150.0f * this.lightStrength);
        Color tailColor = FireflyMob.getFireflyGlowColor(this.fireflyType, this.lightStrength);
        float rndX = this.x + (float)(GameRandom.globalRandom.nextGaussian() * 4.0);
        float rndY = this.y - (float)this.getFlyingHeight() + (float)(GameRandom.globalRandom.nextGaussian() * 4.0);
        this.getLevel().entityManager.addParticle(rndX, rndY, Particle.GType.IMPORTANT_COSMETIC).sprite(GameResources.bubbleParticle.sprite(0, 0, 12)).color(tailColor).minDrawLight(120).height(10.0f).alpha(this.lightStrength).dontRotate().movesConstant(0.0f, -1.0f).fadesAlphaTimeToCustomAlpha(250, 250, 1.0f).size((options, lifeTime, timeAlive, lifePercent) -> options.size(6)).lifeTime(800);
    }

    @Override
    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        if (this.lightStrength <= 0.0f) {
            return;
        }
        Color tailColor = FireflyMob.getFireflyGlowColor(this.fireflyType, this.lightStrength);
        int flyHeight = this.getFlyingHeight();
        int drawX = camera.getDrawX(x);
        int drawY = camera.getDrawY(y);
        Point sprite = this.getWingFlapSpriteAnim();
        final TextureDrawOptionsEnd lightOptions = this.getBugTexture().body.initDraw().sprite(sprite.x + 2, sprite.y, this.spriteRes).color(tailColor).light(new GameLight(120.0f)).alpha(this.lightStrength).pos(drawX - this.spriteRes / 2, (drawY += level.getTile(FireflyMob.getTileCoordinate(x), FireflyMob.getTileCoordinate(y)).getMobSinkingAmount(this)) - (this.spriteRes / 2 + this.spriteRes / 4) - flyHeight);
        list.add(new MobDrawable(){

            @Override
            public void draw(TickManager tickManager) {
                lightOptions.draw();
            }
        });
    }

    @Override
    protected SoundSettings getAmbientSound() {
        return new SoundSettings(GameResources.fireflyAmbient).volume(0.1f).basePitch(0.97f).pitchVariance(0.03f);
    }

    @Override
    public MobSpawnLocation checkSpawnLocation(MobSpawnLocation location) {
        return super.checkSpawnLocation(location).checkTile((tileX, tileY) -> !this.getLevel().getTile((int)tileX.intValue(), (int)tileY.intValue()).isFloor);
    }

    public static enum FireflyType {
        YELLOW(Item.Rarity.NORMAL, "fireflyyellow", 59, new Color(250, 190, 0), 0),
        GREEN(Item.Rarity.COMMON, "fireflygreen", 90, new Color(145, 205, 41), 0),
        BLUE(Item.Rarity.UNCOMMON, "fireflyblue", 200, new Color(25, 159, 255), 30);

        public Item.Rarity rarity;
        public String droppedItemStringID;
        public int emissionHue;
        public int emissionLevel;
        public Color glowColor;

        private FireflyType(Item.Rarity rarity, String droppedItemStringID, int emissionHue, Color glowColor, int emissionLevelDifference) {
            this.rarity = rarity;
            this.droppedItemStringID = droppedItemStringID;
            this.emissionHue = emissionHue;
            this.glowColor = glowColor;
            this.emissionLevel = 40 + emissionLevelDifference;
        }
    }
}

