/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine.network.packet;

import necesse.engine.GameLog;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.client.ClientClient;
import necesse.engine.network.packet.PacketDisconnect;
import necesse.engine.network.packet.PacketRequestPlayerData;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class PacketActiveTrinketBuffAbilityStopped
extends Packet {
    public final int slot;
    public final int uniqueID;

    public PacketActiveTrinketBuffAbilityStopped(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader(this);
        this.slot = reader.getNextByteUnsigned();
        this.uniqueID = reader.getNextInt();
    }

    public PacketActiveTrinketBuffAbilityStopped(int slot, int uniqueID) {
        this.slot = slot;
        this.uniqueID = uniqueID;
        PacketWriter writer = new PacketWriter(this);
        writer.putNextByteUnsigned(slot);
        writer.putNextInt(uniqueID);
    }

    @Override
    public void processClient(NetworkPacket packet, Client client) {
        if (client.getLevel() == null) {
            return;
        }
        ClientClient target = client.getClient(this.slot);
        if (target != null && target.playerMob.getLevel() != null) {
            target.playerMob.onActiveTrinketBuffAbilityStopped(this.uniqueID);
        } else {
            client.network.sendPacket(new PacketRequestPlayerData(this.slot));
        }
    }

    @Override
    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        if (client.slot == this.slot) {
            if (!client.checkHasRequestedSelf() || client.isDead()) {
                return;
            }
            client.playerMob.onActiveTrinketBuffAbilityStopped(this.uniqueID);
            server.network.sendToClientsWithEntityExcept(new PacketActiveTrinketBuffAbilityStopped(this.slot, this.uniqueID), client.playerMob, client);
        } else {
            GameLog.warn.println(client.getName() + " tried to run active trinket buff ability update from wrong slot, kicking him for desync");
            server.disconnectClient(client, PacketDisconnect.Code.STATE_DESYNC);
        }
    }
}

