/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import necesse.engine.GameLog;
import necesse.engine.GlobalData;
import necesse.engine.loading.GameNoticeException;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.LoadedMod;
import necesse.engine.modLoader.ModLoader;
import necesse.engine.modLoader.ModRuntimeException;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.world.RecentJVMECrashException;
import necesse.reports.CrashJFrame;
import necesse.reports.CrashReportData;
import necesse.reports.ModCrashJFrame;
import necesse.reports.NoticeJFrame;
import necesse.reports.RecentCrashJFrame;

public class GameCrashLog {
    private static final String LOG_PATH = "latest-crash.log";

    public static void printCrashLog(Throwable e, Client client, Server server, String state, boolean openCrashReport) {
        GameCrashLog.printCrashLog(Collections.singletonList(e), client, server, state, openCrashReport);
    }

    public static void printCrashLog(List<Throwable> errors, Client client, Server server, String state, boolean openCrashReport) {
        File file = new File(LOG_PATH);
        System.err.println("Printing crash log to " + file.getAbsolutePath());
        try {
            CrashReportData data = new CrashReportData(errors, client, server, state);
            FileOutputStream fo = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fo);
            data.printFullReport(printStream, file);
            fo.close();
            if (client != null) {
                client.serverCrashReport = data;
            }
            if (openCrashReport) {
                GameCrashLog.openCrashFrame(data);
                if (GlobalData.getCurrentGameLoop() != null) {
                    GlobalData.getCurrentGameLoop().stopMainGameLoop();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reportRecentJVMCrashes() {
        try (Stream<Path> pathStream = Files.find(Paths.get("./", new String[0]), 1, (path, attr) -> attr.isRegularFile() && path.getFileName().toString().startsWith("hs_err_pid") && path.toString().endsWith(".log") && attr.creationTime().toInstant().isAfter(Instant.now().minus(30L, ChronoUnit.MINUTES)), FileVisitOption.FOLLOW_LINKS);){
            boolean isFirst = true;
            List paths = pathStream.collect(Collectors.toList());
            for (Path path2 : paths) {
                GameLog.warn.println("Found recent crash file: " + path2);
                if (isFirst) {
                    isFirst = false;
                    try {
                        List<String> lines = Files.readAllLines(path2, StandardCharsets.UTF_8);
                        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
                        throwables.add(new RecentJVMECrashException(lines));
                        RecentCrashJFrame.showAndBlock(new CrashReportData(throwables, null, null, "startup"));
                    }
                    catch (IOException e) {
                        System.err.println("Could not report recent JVM crash because of error:");
                        e.printStackTrace();
                    }
                }
                File file = path2.toFile();
                file.renameTo(new File(file.getParentFile(), file.getName() + ".old"));
            }
        }
        catch (IOException e) {
            GameLog.warn.println("Failed to check for recent JVM crashes. See exception below.");
            e.printStackTrace(GameLog.warn);
        }
    }

    public static void openCrashFrame(CrashReportData data) {
        Throwable[] modExceptions = (ModRuntimeException[])data.errors.stream().filter(e -> e instanceof ModRuntimeException).map(e -> (ModRuntimeException)e).toArray(ModRuntimeException[]::new);
        if (modExceptions.length > 0) {
            ModCrashJFrame crashJFrame = new ModCrashJFrame(Collections.singletonList(modExceptions[0].mod), modExceptions);
            crashJFrame.setVisible(true);
            crashJFrame.requestFocus();
        } else {
            ArrayList<LoadedMod> responsibleMods = ModLoader.getResponsibleMods(data.errors, true);
            if (!responsibleMods.isEmpty()) {
                ModCrashJFrame crashJFrame = new ModCrashJFrame(responsibleMods, data.errors.toArray(new Exception[0]));
                crashJFrame.setVisible(true);
                crashJFrame.requestFocus();
                return;
            }
            GameNoticeException noticeException = GameCrashLog.findAnyCause(data.errors, GameNoticeException.class, null);
            if (noticeException != null) {
                NoticeJFrame noticeFrame = new NoticeJFrame(400, noticeException.message.translate());
                noticeFrame.setVisible(true);
                noticeFrame.requestFocus();
            } else if (GameCrashLog.findAnyCause(data.errors, OutOfMemoryError.class, null) != null) {
                NoticeJFrame noticeFrame = new NoticeJFrame(400, Localization.translate("misc", "outofmemory"));
                noticeFrame.setVisible(true);
                noticeFrame.requestFocus();
            } else {
                CrashJFrame crashFrame = new CrashJFrame(data);
                crashFrame.setVisible(true);
                crashFrame.requestFocus();
            }
        }
    }

    public static <T extends Throwable> T findAnyCause(Iterable<Throwable> errors, Class<T> throwableClass, Predicate<T> predicate) {
        for (Throwable error : errors) {
            Throwable cause;
            if (!throwableClass.isAssignableFrom(error.getClass()) || (cause = GameCrashLog.findAnyCause((Throwable)throwableClass.cast(error), throwableClass, predicate)) == null) continue;
            return (T)cause;
        }
        return null;
    }

    public static <T extends Throwable> T findAnyCause(T error, Class<T> throwableClass, Predicate<T> predicate) {
        if (predicate == null || predicate.test(error)) {
            return error;
        }
        Throwable cause = error.getCause();
        if (cause != null) {
            if (!throwableClass.isAssignableFrom(error.getClass())) {
                return null;
            }
            return (T)GameCrashLog.findAnyCause((Throwable)throwableClass.cast(cause), throwableClass, predicate);
        }
        return null;
    }
}

