/*
 * Decompiled with CFR 0.152.
 */
package necesse.engine.quest;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import necesse.engine.Settings;
import necesse.engine.achievements.Achievement;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.server.ServerClient;
import necesse.engine.playerStats.PlayerStats;
import necesse.engine.quest.Quest;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.util.GameUtils;
import necesse.gfx.drawOptions.DrawOptionsBox;
import necesse.gfx.drawOptions.DrawOptionsList;
import necesse.gfx.drawOptions.StringDrawOptions;
import necesse.gfx.fairType.FairItemGlyph;
import necesse.gfx.fairType.FairType;
import necesse.gfx.fairType.TypeParsers;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.lootTable.LootList;
import necesse.level.maps.levelData.settlementData.settlementQuestTiers.SettlementQuestTier;

public class CompleteTierXIncursionQuest
extends Quest {
    public GameMessage settlementName;
    public GameMessage hintDescription;
    public String questTier;
    protected ArrayList<IncursionTierObjective> objectives = new ArrayList();

    public CompleteTierXIncursionQuest() {
    }

    public CompleteTierXIncursionQuest(GameMessage settlementName, String questTier, int incursionTier) {
        this.settlementName = settlementName;
        this.questTier = questTier;
        this.objectives.add(new IncursionTierObjective(incursionTier));
    }

    public CompleteTierXIncursionQuest(GameMessage settlementName, String questTier, int incursionTier, GameMessage hintDescription) {
        this(settlementName, questTier, incursionTier);
        this.hintDescription = hintDescription;
    }

    @Override
    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        if (this.settlementName != null) {
            save.addSaveData(this.settlementName.getSaveData("settlementName"));
        }
        if (this.questTier != null) {
            save.addSafeString("questTier", this.questTier);
        }
        if (this.hintDescription != null) {
            save.addSaveData(this.hintDescription.getSaveData("hintDescription"));
        }
        for (IncursionTierObjective objective : this.objectives) {
            SaveData objectiveData = new SaveData("objective");
            objectiveData.addInt("incursionTier", objective.incursionTier);
            save.addSaveData(objectiveData);
        }
    }

    @Override
    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.settlementName = GameMessage.loadSave(save, "settlementName", false);
        this.questTier = save.getSafeString("questTier", null, false);
        this.hintDescription = GameMessage.loadSave(save, "hintDescription", false);
        this.objectives.clear();
        for (LoadData objectiveData : save.getLoadDataByName("objective")) {
            int incursionTier = objectiveData.getInt("incursionTier", 1);
            this.objectives.add(new IncursionTierObjective(incursionTier));
        }
        if (this.objectives.isEmpty()) {
            throw new IllegalStateException("Could not find any objectives");
        }
    }

    @Override
    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        if (this.settlementName != null) {
            writer.putNextBoolean(true);
            this.settlementName.writePacket(writer);
        } else {
            writer.putNextBoolean(false);
        }
        int tierQuestIndex = this.questTier == null ? -1 : SettlementQuestTier.getTierIndex(this.questTier);
        writer.putNextShort((short)tierQuestIndex);
        if (this.hintDescription != null) {
            writer.putNextBoolean(true);
            this.hintDescription.writePacket(writer);
        } else {
            writer.putNextBoolean(false);
        }
        writer.putNextShortUnsigned(this.objectives.size());
        for (IncursionTierObjective objective : this.objectives) {
            writer.putNextInt(objective.incursionTier);
        }
    }

    @Override
    public void applySpawnPacket(PacketReader reader) {
        SettlementQuestTier tier;
        short questTierIndex;
        super.applySpawnPacket(reader);
        if (reader.getNextBoolean()) {
            this.settlementName = GameMessage.fromPacket(reader);
        }
        if ((questTierIndex = reader.getNextShort()) != -1 && (tier = SettlementQuestTier.getTier(questTierIndex)) != null) {
            this.questTier = tier.stringID;
        }
        if (reader.getNextBoolean()) {
            this.hintDescription = GameMessage.fromPacket(reader);
        }
        this.objectives.clear();
        int total = reader.getNextShortUnsigned();
        for (int i = 0; i < total; ++i) {
            int incursionTier = reader.getNextInt();
            this.objectives.add(new IncursionTierObjective(incursionTier));
        }
    }

    @Override
    public GameMessage getTitle() {
        return new LocalMessage("quests", "settlementquest", "settlement", this.settlementName == null ? new LocalMessage("ui", "settlement") : this.settlementName);
    }

    @Override
    public void tick(ServerClient client) {
    }

    @Override
    public boolean canComplete(NetworkClient client) {
        for (IncursionTierObjective objective : this.objectives) {
            PlayerStats stats = client.isServer() ? client.getServerClient().characterStats() : client.getClientClient().getClient().characterStats;
            if (stats.completed_incursions.getTotalTiersAbove(objective.incursionTier, true) > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public GameMessage getDescription() {
        return null;
    }

    @Override
    public FairType getRewardType(NetworkClient client, boolean outlined) {
        if (this.questTier == null) {
            return null;
        }
        SettlementQuestTier questTier = SettlementQuestTier.getTier(this.questTier);
        if (questTier == null) {
            return null;
        }
        LootList rewards = questTier.getTierRewardsDisplayList();
        StringBuilder builder = new StringBuilder();
        boolean isFirstReward = true;
        for (Item item : rewards.getItems()) {
            if (!isFirstReward) {
                builder.append(", ");
            }
            builder.append(TypeParsers.getItemParseString(new InventoryItem(item)));
            builder.append(" ").append(ItemRegistry.getDisplayName(item.getID()));
            isFirstReward = false;
        }
        if (builder.length() == 0) {
            return null;
        }
        FontOptions rewardFontOptions = new FontOptions(12).outline(outlined);
        FairType fairType = new FairType();
        fairType.append(rewardFontOptions, Localization.translate("quests", "reward", "reward", builder.toString()));
        fairType.applyParsers(TypeParsers.ItemIcon(rewardFontOptions.getSize(), true, FairItemGlyph::onlyShowNameTooltip));
        return fairType;
    }

    @Override
    public FairType getHandInType(NetworkClient client, boolean outlined) {
        if (this.settlementName == null) {
            return null;
        }
        FontOptions handInFontOptions = new FontOptions(12).outline(outlined);
        FairType fairType = new FairType();
        fairType.append(handInFontOptions, Localization.translate("quests", "handinelder", "settlement", this.settlementName.translate()));
        return fairType;
    }

    @Override
    public DrawOptionsBox getProgressDrawBox(NetworkClient client, final int x, final int y, final int width, Color textColor, boolean outlined) {
        final DrawOptionsList drawOptions = new DrawOptionsList();
        int currentHeight = 0;
        for (IncursionTierObjective objective : this.objectives) {
            String str = Localization.translate("quests", "completeincursiontier", "tier", (Object)objective.incursionTier);
            FontOptions fontOptions = new FontOptions(16).outline(outlined);
            if (textColor != null) {
                fontOptions.color(textColor);
            }
            drawOptions.add(new StringDrawOptions(fontOptions, str).pos(x, y + currentHeight));
            currentHeight += 16;
            if (this.hintDescription != null) {
                FontOptions hintDescriptionFontOptions = new FontOptions(12).outline(outlined);
                if (textColor != null) {
                    hintDescriptionFontOptions.color(textColor);
                }
                ArrayList<String> lines = GameUtils.breakString(this.hintDescription.translate(), hintDescriptionFontOptions, width + 25);
                for (String line : lines) {
                    drawOptions.add(new StringDrawOptions(hintDescriptionFontOptions, line).pos(x, y + currentHeight + 2));
                    currentHeight += 12;
                }
                currentHeight += 4;
            }
            int progress = this.canComplete(client) ? 1 : 0;
            Color col = progress == 1 ? Settings.UI.successTextColor : Settings.UI.errorTextColor;
            FontOptions progressFontOptions = new FontOptions(16).outline(outlined).color(col);
            DrawOptionsBox progressBox = Achievement.getProgressbarTextDrawBox(x, y + currentHeight, width, 5, progress, Settings.UI.progressBarOutline, Settings.UI.progressBarFill, progress + "/" + 1, progressFontOptions);
            drawOptions.add(progressBox);
            currentHeight += progressBox.getBoundingBox().height;
        }
        final int finalHeight = currentHeight;
        return new DrawOptionsBox(){

            @Override
            public Rectangle getBoundingBox() {
                return new Rectangle(x, y, width, finalHeight);
            }

            @Override
            public void draw() {
                drawOptions.draw();
            }
        };
    }

    public static class IncursionTierObjective {
        protected int incursionTier;

        public IncursionTierObjective(int incursionTier) {
            this.incursionTier = incursionTier;
        }
    }
}

