/*
 * Decompiled with CFR 0.152.
 */
package necesse.entity.mobs.ai.behaviourTree.trees;

import java.awt.geom.Point2D;
import java.util.function.Supplier;
import necesse.engine.network.packet.PacketMobAttack;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.event.ConfuseWanderAIEvent;
import necesse.entity.mobs.ai.behaviourTree.trees.SharkAI;
import necesse.entity.mobs.hostile.SharkMob;

public class FakeSharkAI<T extends SharkMob>
extends SharkAI<T> {
    public FakeSharkAI(int searchDistance) {
        super(searchDistance);
        this.critterAttackCooldown = 15000L;
    }

    @Override
    protected boolean sharkAttack(T mob, Mob target, Supplier<Boolean> superAttackTarget) {
        if (!target.canBeHit((Attacker)mob)) {
            return false;
        }
        ((Entity)mob).getServer().network.sendToAllClients(new PacketMobAttack((Mob)mob, ((Entity)mob).getX(), ((Entity)mob).getY(), true));
        Point2D.Float attackDir = GameMath.normalize(target.x - ((SharkMob)mob).x, target.y - ((SharkMob)mob).y);
        float attackAngle = GameMath.getAngle(attackDir);
        float runAwayAngle = GameMath.fixAngle(attackAngle + GameRandom.globalRandom.getFloatBetween(-20.0f, 20.0f));
        Point2D.Float runAwayDir = GameMath.getAngleDir(runAwayAngle);
        int confuseTime = GameRandom.globalRandom.getIntBetween(3000, 5000);
        this.getBlackboard().submitEvent("confuseWander", new ConfuseWanderAIEvent(confuseTime, runAwayDir));
        return true;
    }
}

