/*
 * Decompiled with CFR 0.152.
 */
package necesse.entity.mobs.buffs.staticBuffs;

import java.awt.Color;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ParticleOption;
import necesse.gfx.GameResources;
import necesse.gfx.drawOptions.texture.SharedTextureDrawOptions;

public class BleedDebuff
extends Buff {
    public BleedDebuff() {
        this.isImportant = true;
        this.isVisible = true;
        this.canCancel = false;
    }

    protected float getDamagePerSecond(ActiveBuff buff) {
        float bleedDamagePerSec = buff.getGndData().getFloat("damagepersec");
        if (bleedDamagePerSec != 0.0f) {
            return bleedDamagePerSec;
        }
        return 5.0f;
    }

    @Override
    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.BLEED_DAMAGE_FLAT, Float.valueOf(this.getDamagePerSecond(buff)));
    }

    @Override
    public int getStackSize(ActiveBuff buff) {
        return 1;
    }

    @Override
    public void clientTick(ActiveBuff buff) {
        super.clientTick(buff);
        if (buff.owner.isVisible() && GameRandom.globalRandom.getEveryXthChance(4)) {
            Mob owner = buff.owner;
            float variance = 0.4f;
            float xDir = GameRandom.globalRandom.getFloatBetween(-variance, variance);
            float yVariance = GameRandom.globalRandom.getFloatBetween(10.0f, 20.0f);
            owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 5.0), owner.y + 23.0f + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).sprite(GameResources.particles.sprite(0, 0, 8)).color(new Color(182, 12, 12)).dontRotate().height(32.0f).moves((pos, delta, lifeTime, timeAlive, lifePercent) -> {
                pos.x += xDir;
                float heightFactor = (float)(-Math.pow(0.6 - 1.6 * (double)lifePercent, 2.0)) + 1.0f;
                pos.y = owner.y + 32.0f + yVariance - heightFactor * 25.0f;
            }).fadesAlphaTimeToCustomAlpha(200, 200, 0.9f).size(new ParticleOption.DrawModifier(){

                @Override
                public void modify(SharedTextureDrawOptions.Wrapper options, int lifeTime, int timeAlive, float lifePercent) {
                    options.size(10, 10);
                }
            }).lifeTime(500);
        }
    }
}

