/*
 * Decompiled with CFR 0.152.
 */
package necesse.gfx;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import necesse.engine.util.GameRandom;
import necesse.engine.util.TicketSystemList;
import necesse.gfx.GameResources;
import necesse.gfx.GameSkin;
import necesse.gfx.GameSkinColors;
import necesse.gfx.HumanGender;
import necesse.gfx.gameTexture.GameTexture;

public class GameEyes {
    public static boolean printDebugs = false;
    public static GameSkinColors colors;
    private static ArrayList<GameEyes> eyes;
    public static GameTexture recolorLookupTexture;
    public static GameTexture defaultClosedEyeTexture;
    public static GameTexture defaultClosedSkinTexture;
    public static GameTexture defaultOpenEyeTexture;
    public static GameTexture defaultOpenSkinTexture;
    public final int eyeIndex;
    public final int weight;
    private final HumanGender gender;
    public GameTexture openEyeColorTexture;
    public GameTexture openSkinColorTexture;
    public GameTexture closedEyeColorTexture;
    public GameTexture closedSkinColorTexture;

    public static void loadEyeTypes() {
        eyes = new ArrayList();
        eyes.add(new GameEyes(1, 100, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(2, 100, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(3, 25, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(4, 50, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(5, 10, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(6, 0, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(7, 0, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(8, 0, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(9, 50, HumanGender.FEMALE));
        eyes.add(new GameEyes(10, 25, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(11, 25, HumanGender.NEUTRAL));
        eyes.add(new GameEyes(12, 10, HumanGender.NEUTRAL));
    }

    public static void loadEyeTextures() {
        GameEyes.loadColors();
        GameTexture defaultClosedTexture = GameTexture.fromFile("player/eyes/eyes_closed", true);
        GameTexture[] textures = GameEyes.loadTextures(defaultClosedTexture);
        defaultClosedEyeTexture = textures[0];
        defaultClosedSkinTexture = textures[1];
        for (GameEyes eye : eyes) {
            eye.loadTextures();
        }
    }

    private static void loadColors() {
        colors = new GameSkinColors();
        String colorsPath = "player/eyes/eyecolors";
        try {
            recolorLookupTexture = GameTexture.fromFileRaw(colorsPath, true);
            colors.addBaseColors(recolorLookupTexture, 0, 1, recolorLookupTexture.getWidth() - 1);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find eye colors texture file at " + colorsPath);
        }
    }

    private static GameTexture[] loadTextures(GameTexture originalTexture) {
        GameTexture[] textures = new GameTexture[]{GameEyes.loadTexture(originalTexture, colors, GameSkin.colors), GameEyes.loadTexture(originalTexture, GameSkin.colors, colors)};
        return textures;
    }

    private static GameTexture loadTexture(GameTexture originalTexture, GameSkinColors colors, GameSkinColors removeTones) {
        GameTexture texture = new GameTexture(originalTexture);
        HashSet<Color> excludes = new HashSet<Color>(colors.getToneColors());
        colors.removeToneColors(texture, removeTones.getToneColors(), excludes);
        colors.replaceIndexColors(texture, 1);
        texture.runPreAntialias(false);
        texture.makeFinal();
        return texture;
    }

    private GameEyes(int eyeIndex, int weight, HumanGender gender) {
        this.eyeIndex = eyeIndex;
        this.weight = weight;
        this.gender = gender;
    }

    private void loadTextures() {
        GameTexture[] textures;
        block5: {
            block4: {
                textures = new GameTexture[]{defaultOpenEyeTexture, defaultOpenSkinTexture};
                try {
                    GameTexture openTexture = GameTexture.fromFileRaw("player/eyes/eyes" + this.eyeIndex, true);
                    textures = GameEyes.loadTextures(openTexture);
                }
                catch (FileNotFoundException e) {
                    if (defaultOpenEyeTexture != null && defaultOpenSkinTexture != null) break block4;
                    textures = GameEyes.loadTextures(GameResources.error);
                }
            }
            this.openEyeColorTexture = textures[0];
            this.openSkinColorTexture = textures[1];
            textures = new GameTexture[]{defaultClosedEyeTexture, defaultClosedSkinTexture};
            try {
                GameTexture closedTexture = GameTexture.fromFileRaw("player/eyes/eyes" + this.eyeIndex + "_closed", true);
                textures = GameEyes.loadTextures(closedTexture);
            }
            catch (FileNotFoundException e) {
                if (defaultClosedEyeTexture != null && defaultClosedSkinTexture != null) break block5;
                GameEyes.loadTextures(GameResources.error);
            }
        }
        this.closedEyeColorTexture = textures[0];
        this.closedSkinColorTexture = textures[1];
    }

    public <T> List<T> getOpenTextures(Function<GameTexture, T> eyeMapper, Function<GameTexture, T> skinMapper) {
        return Arrays.asList(skinMapper.apply(this.openSkinColorTexture), eyeMapper.apply(this.openEyeColorTexture));
    }

    public <T> List<T> getClosedTextures(Function<GameTexture, T> eyeMapper, Function<GameTexture, T> skinMapper) {
        return Arrays.asList(skinMapper.apply(this.closedSkinColorTexture), eyeMapper.apply(this.closedEyeColorTexture));
    }

    public static int getTotalEyeTypes() {
        return eyes.size();
    }

    public static int getTotalColors() {
        return colors.getSize();
    }

    public static GameEyes getEyes(int eyeType) {
        return eyes.get(eyeType % eyes.size());
    }

    public static int getRandomEyeColor(GameRandom random) {
        if (colors == null || colors.getSize() <= 0) {
            return random.nextInt();
        }
        TicketSystemList ticketList = new TicketSystemList();
        for (int i = 0; i < colors.getSize(); ++i) {
            ticketList.addObject(colors.getWeight(i), (Object)i);
        }
        return (Integer)ticketList.getRandomObject(random);
    }

    public static int getRandomEyesBasedOnGender(GameRandom random, HumanGender gender) {
        if (eyes == null || eyes.isEmpty()) {
            return random.nextInt();
        }
        TicketSystemList ticketList = new TicketSystemList();
        for (int i = 0; i < eyes.size(); ++i) {
            HumanGender eyeGender = GameEyes.eyes.get((int)i).gender;
            if (eyeGender != gender && eyeGender != HumanGender.NEUTRAL) continue;
            ticketList.addObject(GameEyes.eyes.get((int)i).weight, (Object)i);
        }
        if (ticketList.isEmpty()) {
            return random.nextInt();
        }
        return (Integer)ticketList.getRandomObject(random);
    }
}

