/*
 * Decompiled with CFR 0.152.
 */
package necesse.inventory.container.object;

import java.io.IOException;
import java.util.zip.DataFormatException;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketMapData;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.entity.objectEntity.CartographerTableObjectEntity;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.ContainerCustomAction;
import necesse.level.maps.mapData.BasicDiscoveredMapManager;

public class CartographersTableContainer
extends Container {
    public CartographerTableObjectEntity tableObjectEntity;
    public final ShareDiscoveriesWithPlayerAction shareWithPlayer;

    public CartographersTableContainer(NetworkClient client, int uniqueSeed, CartographerTableObjectEntity tableObjectEntity) {
        super(client, uniqueSeed);
        this.tableObjectEntity = tableObjectEntity;
        this.shareWithPlayer = this.registerAction(new ShareDiscoveriesWithPlayerAction());
    }

    @Override
    public void init() {
        super.init();
        this.tableObjectEntity.addUsingClient(this.client);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.tableObjectEntity.removeUsingClient(this.client);
    }

    public class ShareDiscoveriesWithPlayerAction
    extends ContainerCustomAction {
        public void runAndSend(int playerSlot, BasicDiscoveredMapManager mapData) throws DataFormatException, IOException {
            Packet content = new Packet();
            PacketWriter writer = new PacketWriter(content);
            writer.putNextShortUnsigned(playerSlot);
            Packet mapContent = new Packet();
            mapData.writePacketData(new PacketWriter(mapContent));
            writer.putNextContentPacket(mapContent);
            this.runAndSendAction(content);
        }

        @Override
        public void executePacket(PacketReader reader) {
            if (!CartographersTableContainer.this.client.isServer()) {
                return;
            }
            int playerSlot = reader.getNextShortUnsigned();
            if (CartographersTableContainer.this.tableObjectEntity.hasClientUsing(playerSlot)) {
                Packet mapContentPacket = reader.getNextContentPacket();
                Server server = CartographersTableContainer.this.client.getServerClient().getServer();
                ServerClient otherClient = server.getClient(playerSlot);
                otherClient.sendPacket(new PacketMapData(CartographersTableContainer.this.client.slot, mapContentPacket));
            }
        }
    }
}

